#include "mbed.h"
#include "WDT.h"

//const int _ID = 4;

void irqrecv();
int rs485_recv(float ,float ,float ,float ,float);
char rsgetc();
int rslen();

Serial pc(SERIAL_TX,SERIAL_RX);
Serial modem(D1,D0);
AnalogIn adc_1(A0);
AnalogIn adc_2(A1);
AnalogIn adc_3(A2);
AnalogIn adc_4(A3);

DigitalOut led(LED1);
DigitalOut sokutei(D3);
DigitalOut pos1(D4);
DigitalOut pos2(D5);
DigitalIn in1(D9,PullNone);
DigitalIn in2(D10,PullNone);
DigitalIn kansyutu(D6,PullNone);
DigitalIn commandin(D7,PullNone);
DigitalIn jmp(D2,PullUp);
DigitalIn pulse1(D9,PullNone);
DigitalIn pulse2(D10,PullNone);

Timer pulse_watcher;


#define bufsize 2048
char RxBuff[bufsize+1];
int RxPtr;
int RdPtr;

int data[40];


char rsgetc() {

    RdPtr++;
    if(RdPtr >= bufsize-1) RdPtr = 0;
    return(RxBuff[RdPtr]);
}    

int rslen() {
//    if (RxPtr < RdPtr) {
//        return(bufsize + RxPtr - RdPtr);
//    } else {
//        return(RxPtr - RdPtr);
//    }
    return(RxPtr - RdPtr);
}
    
void irqrecv() {
    if (modem.readable()) {
        if (RxPtr <= bufsize - 1) {
            RxBuff[++RxPtr] = modem.getc();
        } else {
            RxPtr = 0;
            RxBuff[RxPtr] = modem.getc();
        }
    }
}

//unsigned char buf485[512];
unsigned char buf485[2048];
int cnt485;

// 20190912 K.Hirasawa 
// WDT&Count de Taisaku
// Fleeze ha WDT de taisakuzumi.
// RS485 no kaisenn nigittamama monndai nara CountOver de Reset.
int cntOver;

int main()
{
    float sum1,sum2,sum3,sum4;
    float ad1,ad2,ad3,ad4;
    static float temp;//,turb,s;
    int i,cnt;
    int pulse;

    pc.printf("\n--Initial Start--\r\n");

    WDT wdgTimer;
    cntOver = 0;
    
    wdgTimer.Configure(10);

    modem.baud(38400);
    modem.format(8,Serial::None,1);    
    RxPtr = 0;
    RdPtr = 0;
    modem.attach(irqrecv,RawSerial::RxIrq);
    cnt485 = 0;
    buf485[0] = '\0';

    wdgTimer.Service();


    pos1 = 1;
    pos2 = 1;

    temp = 0;
//    turb = 0;
//    s = 0;
    sokutei = 1;
    pulse_watcher.start();
    pulse = pulse1 || pulse2;



    for (i = 0;i<40;i++) {
        data[i] = 0;
        wdgTimer.Service();
    }

    pc.printf("\n--Initial End--\r\n");

    while(1) {
        if (pulse_watcher.read() > 100) pulse_watcher.reset();
        
//        if (jmp) sokutei = 1;
//        else sokutei = 0;

//        if (jmp) {
//            pos1 = 1;
//            pos2 = 1;
//        } else {
//            pos1 = 0;
//            pos2 = 0;
//        }
        
        sum1 = 0;
        sum2 = 0;
        sum3 = 0;
        sum4 = 0;
        cnt = 0;
        for (i=0;i<1000;i++) {
            rs485_recv(temp,ad1,ad2,ad3,ad4);

            sum1 += adc_1.read();
            sum2 += adc_2.read();
            sum3 += adc_3.read();
            sum4 += adc_4.read();
            cnt += 1;
            wait(0.001);

//            if (modem.readable()) {
//                pc.printf("%c\r",modem.getc());
//                wait(0.01);
//                modem.printf("=04,PVAL,%01.04f,0,\r",temp);
//            }
            // pulse watch
            if ( (pulse1 || pulse2) != pulse ) {
                pulse_watcher.reset();
                pos1 = 0;
                pos2 = 0;
            }
            pulse = pulse1 || pulse2;
            if ( pulse_watcher.read() > 10) {
                pos1 = 1;
                pos2 = 1;
            }
            
//            if (jmp != 0) wdgTimer.Service();
            wdgTimer.Service();

            // pulsewatch
        }
        if(cnt != 0) {
            ad1 = sum1/cnt;
            ad2 = sum2/cnt;
            ad3 = sum3/cnt;
            ad4 = sum4/cnt;
        } else {
            ad1 = adc_1.read();
            ad2 = adc_2.read();
            ad3 = adc_3.read();
            ad4 = adc_4.read();
        }
        
        if (ad1 < 0.2435L) ad1 = 0.2435L;
        if (ad1 > 0.8085L) ad1 = 0.8085L;
        
        temp = (double)(ad1 - 0.2435L) * 60.0L / (0.8085L - 0.2425L) - 10.0L;
//        pc.printf("ADC = %f  %f  %f  %f %f \r\n", ad1,ad2,ad3,ad4,temp);
//        s = 0;
        
        // data set
        data[8] = ad1 * 0xffff;
        data[9] = ad2 * 0xffff;
        data[10] = ad3 * 0xffff;
        data[12] = ad4 * 0xffff;

        //WDT test
//        if (jmp == 0) while(1) ; 

//        wdg.kick(); // IWDGをリセット
//        if (jmp != 0) wdgTimer.Service();

        cntOver += 1; // 1s ni ikkai CountUp
        wdgTimer.Service();
        
        if (cntOver > 60) {
            wdgTimer.Configure(1);
            while(1) {;}    
        }
    }
}


int rs485_recv(float temp,float ad1,float ad2,float ad3,float ad4) {
    char chr;    
//    char idbuf[8];
    char sendbuf[512];
//    int i;
    
    if (rslen()) {
        chr = rsgetc();
        buf485[cnt485++] = chr;
        buf485[cnt485] = '\0';
        if (chr == '?') cnt485 = 0;
        
        if (chr == 0x0a) {
            // 20190912 K.Hirasawa
            cntOver = 0; // Jyusin ari!        
        
//        pc.printf("CR\r\n");
            
            if( ('C' == buf485[0]) ) {
                if (kansyutu) data[0] = 1;
                else data[0] = 0;

                // sokutei on/off
                if( buf485[2] & 0x05 ) {
                    sokutei = 1;
                    data[0] = data[0] | 64 | 128;
                } else {
                    sokutei = 0;
                }
                if( buf485[2] & 0x0a ) {
                    wait(0.1);
                    modem.printf("?00,WIPE,1,\r");
                } else {
                    // answer
                    sprintf(sendbuf,"=%04x,%04x,%04x,%04x,%04x,%04x,%04x,%04x,%04x,%04x,%04x,%04x,%04x,%04x,%04x,%04x,%04x,%04x,%04x,%04x,%04x,%04x,%04x,%04x,%04x,%04x,%04x,%04x,%04x,%04x,%04x,%04x,%04x,%04x,%04x,%04x,%04x,%04x,%04x,%04x\r\n", 
                     data[0],data[1],data[2],data[3],data[4],data[5],data[6],data[7],data[8],data[9],
                     data[10],data[11],data[12],data[13],data[14],data[15],data[16],data[17],data[18],data[19],
                     data[20],data[21],data[22],data[23],data[24],data[25],data[26],data[27],data[28],data[29],
                     data[30],data[31],data[32],data[33],data[34],data[35],data[36],data[37],data[38],data[39]
                    );
                    //modem.printf("=%c%c,PVAL,%01.04f,%01.04f,%01.04f,%01.04f,%01.04f,%01d\r", 0x30 | idbuf[0],0x30 | idbuf[1],temp,ad1,ad2,ad3,ad4,kan);
                    
                    wait(0.1);
                    modem.printf("%s",sendbuf);
                    pc.printf("%s",sendbuf);
                }
            }
            RxPtr = 0;
            RdPtr = 0;
            RxBuff[0] = '\0';
            buf485[0] = '\0'; // clear
            cnt485 = 0;
        }
   }
    return(0);
}


