/*************************** queue.cpp ***************************************/
/*                                                                           */
/*****************************************************************************/

#include "queueChar.h"

/***************************** constructor ***********************************/
/* Description:                                                              */
/*****************************************************************************/

queueChar::queueChar()
{
    front = 0;
    end = 0;
    lengthVar = 0;
    for (int i = 0; i < MAXQUEUECHARLENGTH; i++)
    {
        buffer[i] = 0;
    }
}

/******************************* distructor **********************************/
/* Description:                                                              */
/*****************************************************************************/

queueChar::~queueChar()
{
    clear();        // Clear the entire queue.
}

/*****************************************************************************/
/* Description:                                                              */
/* Accepts:                                                                  */
/* Returns:                                                                  */
/*****************************************************************************/

bool queueChar::isEmpty()
{
    bool empty = front == end;
    if (empty) lengthVar = 0;
    return empty;
}

/*****************************************************************************/
/* Description:                                                              */
/* Accepts:                                                                  */
/* Returns:                                                                  */
/*****************************************************************************/

void queueChar::clear()
{
    lengthVar = 0;
    front = 0;
    end = 0;
}

/*****************************************************************************/
/* Description:                                                              */
/* Accepts:                                                                  */
/* Returns:                                                                  */
/*****************************************************************************/

void queueChar::add( char data )
{
    buffer[front] = data;
    front = nextIndex(front);
    if (front == end)
        end = nextIndex(end);
    else
        lengthVar++;
}

/*****************************************************************************/
/* Description:                                                              */
/* Accepts:                                                                  */
/* Returns:                                                                  */
/*****************************************************************************/

char queueChar::pop()
{
    if (isEmpty())
        return 255;
    else
    {
        lengthVar--;
        char data = buffer[end];
        end = nextIndex(end);
        return data;
    }
}

/*****************************************************************************/
/* Description:                                                              */
/* Accepts:                                                                  */
/* Returns:                                                                  */
/*****************************************************************************/

char queueChar::peek()
{
//    return front;
    char data = buffer[end];
    return data;
}

/*****************************************************************************/
/* Description:                                                              */
/* Accepts:                                                                  */
/* Returns:                                                                  */
/*****************************************************************************/

char queueChar::length()
{
    short diff = front - end;
    if (diff < 0)
        diff += MAXQUEUECHARLENGTH;
//    diff = diff % MAXQUEUECHARLENGTH;
    return diff;
//    if (diff == lengthVar)
//        return lengthVar;
//    else
//        lengthVar = diff;
//        return 255;
}


char queueChar::nextIndex(char index)
{
    index++;
    if (index >= MAXQUEUECHARLENGTH)
        index = 0;
    return index;
}