/**************************** queue.h ****************************************/
/*                                                                           */
/*  Authers: Greg Abdo.                                                      */
/*  Date:    February 23, 2013                                               */
/*  Version: 1.0                                                             */
/*                                                                           */
/* The queue is used to stack StructureItem in order with a FILO arrangement.*/
/*****************************************************************************/

#ifndef QUEUE_H
#define QUEUE_H

#include "mbed.h"

using namespace std;

const int MAXQUEUELENGTH = 12;

class queue
{
public: 
    queue();                        // Queue constructor
    ~queue();                       // Queue destructor

    bool isEmpty();                 // Check for an empty queue.
    void clear();                   // Clears the entire queue.
    void add( short* );              // Push commandData into the queue.
    short* peek();                   // Look at the last item in the queue.
    short* pop();                    // Pop the top item off the queue.
    short queueLength();              // Return how many objects are in the queue.

private:
    int length;
    
    struct queueNode                // Node object for the queue.
    {
        queueNode( short* array )
        {
            data = array;
            next = NULL;
        }

        ~queueNode()
        {}

        short* data;                 // Pointer to the StructureItem object.
        queueNode * next;           // Next node in the queue.
    };  

    queueNode * front;              // Root of the queue.
};

#endif
