/**************************** queue.h ****************************************/
/*                                                                           */
/*  Authers: Greg Abdo.                                                      */
/*  Date:    February 23, 2013                                               */
/*  Version: 1.0                                                             */
/*                                                                           */
/* The queue is used to stack StructureItem in order with a FILO arrangement.*/
/*****************************************************************************/

#ifndef QUEUECHAR_H
#define QUEUECHAR_H

#include "mbed.h"

using namespace std;

const int MAXQUEUECHARLENGTH = 64;

class queueChar
{
public: 
    queueChar();                        // Queue constructor
    ~queueChar();                       // Queue destructor

    bool isEmpty();                 // Check for an empty queue.
    void clear();                   // Clears the entire queue.
    void add( char );              // Push commandData into the queue.
    char peek();                   // Look at the last item in the queue.
    char pop();                    // Pop the top item off the queue.
    char length();              // Return how many objects are in the queue.

private:
    char buffer[MAXQUEUECHARLENGTH];
    char front;
    char end;
    char lengthVar;
    char nextIndex(char);
    

};

#endif
