/****************************** motor.cpp ********************************/
/* Version: 1.0                                                          */
/* Last Updated: June 1, 2013                                            */
/*                                                                       */
/* The motor class is used for motor control using a PWM ECS. When a     */
/*a motor object is created you must pass the PWM pin as the only        */
/*argument.                                                              */
/*************************************************************************/

#include "motor.h"

/************************** motor( PinName ) *****************************/
/* The motor constructor takes the pin to be used as for PWM and sets it */
/*to default safe valuse.                                                */
/*************************************************************************/

motor::motor( PinName pin ) 
{
    pwmPin = new PwmOut( pin );
    pwmPin->period( 0.020 );    // Set the period to 20ms.
    setPulseMin( 0.001000 );    // Set default min pulse.
    setPulseMax( 0.002 );       // Set default max pulse.
    setSpeed( 0 );              // Set motor to stopped.
}

/************************** setSpeed( int ) ******************************/
/* Set speed takes an int value between 0 and 100 and sets the speed of  */
/*the motor based on passed in percent value of speed.                   */
/*************************************************************************/

void motor::setSpeed( int value )
{
    // Is the value to small?
    if( value  < 0 )             // Yup, just set to 0.
        currentSpeed = 0;
    
    // Is the value to large?
    else if( value > 500 )      // Yup, just set to 100. Changed to 500 to increase
        currentSpeed = 500;     // motor control resolution
    
    // Value must be in the correct range.    
    else    
        currentSpeed = value;   // Set the new value.

    // Calculate the value based on pulseMin, pulseMax and currentSpeed.
    pulse = ((pulseMax - pulseMin) / 500 * currentSpeed) + pulseMin;
    pwmPin->pulsewidth( pulse );   // Write the pulse to the pin.
}

/************************** setPulseMin( float ) *************************/
/*                                                                       */
/*************************************************************************/

void motor::setPulseMin( float value )
{
    pulseMin = value;
}

/************************** setPulseMax( float ) *************************/
/*                                                                       */
/*************************************************************************/

void motor::setPulseMax( float value )
{
    pulseMax = value;
}

/*************************** float getSpeed( ) ***************************/
/*                                                                       */
/*************************************************************************/

int motor::getSpeed()
{
    return currentSpeed;
}