/******************************* com.h ***********************************/
/* Version: 1.0                                                          */
/* Last Updated: June 1, 2013                                            */
/*                                                                       */
/* The com class implements reliable data transfer between two nodes     */
/*using a checksum and a sequence number for guaranteed message delivery */
/*over an xbee modem connected to the passed in tx and rx pins. Messages */
/*are received and placed in the rxBuffer to be read when convenient.    */
/*Messages are encoded by sending a byte with the value of the command   */
/*then and int of the command.                                           */
/* Alternative Pins  RX = PTA1,  TX PTA2                                 */
/*************************************************************************/

#ifndef COM_H
#define COM_H

#include "mbed.h"
#include "queue.h"

const int BAUDRATE      = 38400;
const int BUFFERSIZE    = 10;

class com
{  
    public:
        com( PinName, PinName  );   // Setup the com serial port. (tx, rx)
        bool isData();              // Is there data to be read?
        void write( short, short ); // Write to the port.
        short * read();             // Read from the queue.
        
    private:   
        void callback();            // Handle the interrupts.
        void packetBuilder();       // Called by callback to place commandes into the queue.
        
        char buffer[BUFFERSIZE];    // Buffer for holding serial data.
        int bLength;                // Location in the buffer to place next data.
        Serial xbee;                // tx - DIN, rx - DOUT
        
        queue *rxBuffer;            // queue of commands ready to be read.
};

#endif