/*************************** queue.cpp ***************************************/
/*                                                                           */
/*  Authers: Oanh Tran, Ling Lei, Sihao Xie, Greg Abdo.                      */
/*  Date:    February 23, 2013                                               */
/*  Version: 1.0                                                             */
/*                                                                           */
/* The queue is used to stack StructureItem in order with a FILO             */
/*arrangement.                                                               */
/*****************************************************************************/

#include "queue.h"

/***************************** constructor ***********************************/
/* Description:                                                              */
/*****************************************************************************/

queue::queue()
{
    front = NULL;   // Set front to NULL at the start.
}

/******************************* distructor **********************************/
/* Description:                                                              */
/*****************************************************************************/

queue::~queue()
{
    clear();        // Clear the entire queue.
}

/*****************************************************************************/
/* Description:                                                              */
/* Accepts:                                                                  */
/* Returns:                                                                  */
/*****************************************************************************/

bool queue::isEmpty()
{
    // Is the queue empty?
    if( front == NULL ) // Check the front pointer.
        return true;    // Queue is empty, return true.
    
    return false;       // There is atleast one item, not empty.
}

/*****************************************************************************/
/* Description:                                                              */
/* Accepts:                                                                  */
/* Returns:                                                                  */
/*****************************************************************************/

void queue::clear()
{
    // Is the list already empty?
    if( isEmpty() )     // Check for an empty list.
        return;         // List is empty, don't need to do anything.

    queueNode * current = front;    // Create node to help step through list.
    queueNode * placeHold = front;  // Create node to keep place of delete.

    // As long as were not at the end, keep stepping to the next node.
    while( current != NULL)
    {
        placeHold = current->next;  // Hold where we have to go.
        delete current;             // Delete the node.
        current = placeHold;        // Set current to the next node.
    }

    front = NULL;   // Reset the front to NULL;
    length = 0;
}

/*****************************************************************************/
/* Description:                                                              */
/* Accepts:                                                                  */
/* Returns:                                                                  */
/*****************************************************************************/

void queue::add( short * item )
{
    // Were we passed an invalid object somehow?
    if( item == NULL )  // Check for NULL
        return;         // If so, return.

    if( queueLength() > MAXQUEUELENGTH )
        clear();
        
    queueNode * newNode = new queueNode( item );    // Create the new node.

    if( isEmpty() )
        front = newNode;        // Set front to the new node.
        
    else    
    {
        queueNode *temp = front;
        while( temp->next != NULL )
            temp = temp->next;
            
        temp->next = newNode;
    }   
    length++;
}

/*****************************************************************************/
/* Description:                                                              */
/* Accepts:                                                                  */
/* Returns:                                                                  */
/*****************************************************************************/

short * queue::pop()
{
    // Is the list already empty?
    if( isEmpty() )     // Check for an empty list.
        return NULL;    // List is empty, don't need to do anything.

    short* dataHold = front->data;  // Keep track of what were returning. 
    queueNode * oldNode = front;    // Save the old node to be deleted
    front = front->next;            // Set front to next object.
                                    
    delete oldNode;                 // Delete the front node.                     
    length--;                       // Remove one from the length.
    return dataHold;                // return the stuctureItem.
}

/*****************************************************************************/
/* Description:                                                              */
/* Accepts:                                                                  */
/* Returns:                                                                  */
/*****************************************************************************/

short * queue::peek()
{
    if( front != NULL )
        return front->data;

    return NULL;
}

/*****************************************************************************/
/* Description:                                                              */
/* Accepts:                                                                  */
/* Returns:                                                                  */
/*****************************************************************************/

short queue::queueLength()
{
    return length;
}
