/************************* quadCommand.h *********************************/
/*                                                                       */
/*************************************************************************/

#ifndef QUAD_COMMAND_H
#define QUAD_COMMAND_H

#include "mbed.h"
#include "motor.h"
#include "com.h"
#include "DCM.h"
#include "PID.h"

#define TRIM_VALUE .05

// Motor constants.
#define MOTOR1              PTD4        // Pin used for motor 1.
#define MOTOR2              PTA12       // Pin used for motor 2.
#define MOTOR3              PTA4        // Pin used for motor 3.
#define MOTOR4              PTA5        // Pin used for motor 4.

// Xbee constants.
#define TXPIN               PTA2        // Pin used for xbee TX.
#define RXPIN               PTA1        // Pin used for xbee RX.


// Sensor constants.
#define MMA8451_I2C_ADDRESS (0x1d<<1)   // Address of I2C accelerometer.
#define ACCSDA              PTE25       // Pin for accelerometer SDA line.
#define ACCSCL              PTE24       // Pin for accelerometer SCL line.

// PID constants.
#define DEFAULT_WINDUP_GUARD 5.0        // Integral windup.
#define PID_P 1.0                       // Proportional gain.
#define PID_I 0.0                       // Integral gain.
#define PID_D 0.5                       // Derivative gain.
#define MOTOR_UPDATE       150.0        // Motor update speed.

class quadCommand 
{
    public:
        quadCommand();                  // Constructor.
        void run();                     // The main loop.
        void rxInput();                 // Receive data from the Xbee.
        void updateMotors();            // Send PID values to the motors.
        void updateCurrent();           // Update the current telemetry.
        
    private:
        motor *myMotors[4];             // Array of motor objects.
        com *myCom;                     // The com object for Xbee communication.
        DCM *world;                 // Sensors used to observe the world.
        
        PID *pidPitch;                   // PID for pitch.
        PID *pidRoll;                    // PID for roll.
        PID *pidYaw;                     // PID for yaw.
        
        Ticker motorProcess;            // Timer for updating the motors.
        Timer timer;

        float currentThrottle;          // Current throttle.
        float currentPitch;             // Current pitch.
        float currentRoll;              // Current roll.
        float currentYaw;               // Current yaw.
        
        float pitchTrim;                // Trim the pitch.
        float rollTrim;                 // Trim the roll.
        float yawTrim;                  // Trim the yaw.
        
        float targetThrottle;           // Desired throttle.
        float targetPitch;              // Desired pitch.
        float targetRoll;               // Desired roll.
        float targetYaw;                // Desired yaw. 
        float G_Dt;
        int timestamp_old;
        int timestamp;
};

#endif