/******************************* com.h ***********************************/
/* Version: 1.0                                                          */
/* Last Updated: June 1, 2013                                            */
/*                                                                       */
/* The com class implements reliable data transfer between two nodes     */
/*using a checksum and a sequence number for guaranteed message delivery */
/*over an xbee modem connected to the passed in tx and rx pins. Messages */
/*are received and placed in the rxBuffer to be read when convenient.    */
/*Messages are encoded by sending a byte with the value of the command   */
/*then and int of the command.                                           */
/* Alternative Pins  RX = PTA1,  TX PTA2                                 */
/*************************************************************************/

#ifndef COM_H
#define COM_H
#define RSSI_THRES          0.8

#include "mbed.h"
#include "queue.h"
#include "PwmIn.h"

const int BAUDRATE      = 38400;
const int BUFFERSIZE    = 18;

class com
{  
    public:
        com( PinName, PinName, PinName );   // Setup the com serial port. (tx, rx)
        bool isData();              // Is there data to be read?
        bool isSignalGood();
        void write( short, short ); // Write to the port.
        short * read();             // Read from the queue.
        void setAPImode(bool mode);
        void ackCheck();
        bool rdy2ack();
        
    private:         
        Serial xbeeTx;                // tx - DIN, rx - DOUT
        Serial xbeeRx;                // tx - DIN, rx - DOUT
        queue *rxBuffer;            // queue of commands ready to be read.
        queue *txBuffer;
        PwmIn rssi;
          
        bool api_mode;
          
        void callback();            // Handle the interrupts.
        void packetBuilder();       // Called by callback to place commandes into the queue.
        
        char buffer[BUFFERSIZE];    // Buffer for holding serial data.
        int bLength;                // Location in the buffer to place next data.
        int signalStrength;

};

#endif