
#ifndef SENSOR_H
#define SENSOR_H


#define SAMPLE_RATE 200

#define M_PI 3.14159265
#define RAD2DEG 180 / M_PI
#define GYRO_GAIN 0.061035156f
//#define GYRO_GAIN 0.030517578f
//#define GYRO_GAIN 0.015258789f
//#define GYRO_GAIN 0.007629394f

#include "inv_mpu_dmp_motion_driver.h"

class Sensor
{  
    public:
    Sensor();   // Setup the com serial port. (tx, rx)
    int initialize();
    void reset();
    int updateAngles();
    float getYaw();
    float getPitch();
    float getRoll();
    float getGyroYaw();
    float getGyroPitch();
    float getGyroRoll();

        
    private:
    DMP_Motion_Driver dmp;
    Quaternion q;           // [w, x, y, z]         quaternion container
    VectorFloat gravity;    // [x, y, z]            gravity vector
    signed char gyro_orientation[9] ;
    float ypr[3];           // [yaw, pitch, roll]   yaw/pitch/roll container and gravity vector  
    short gyro[3]; 
    short accel[3]; 
    int packetSize;
    uint8_t fifoBuffer[64]; // FIFO storage buffer
    uint8_t mpuIntStatus;
    int fifoCount;
    
    int mpu_initialize();
    int dmp_initialize();
    int run_self_test();

};

#endif
