#ifndef _INV_MPU_H_
#define _INV_MPU_H_

#include "I2Cdev.h"




#define INV_X_GYRO      (0x40)
#define INV_Y_GYRO      (0x20)
#define INV_Z_GYRO      (0x10)
#define INV_XYZ_GYRO    (INV_X_GYRO | INV_Y_GYRO | INV_Z_GYRO)
#define INV_XYZ_ACCEL   (0x08)
#define INV_XYZ_COMPASS (0x01)

#define MPU_INT_STATUS_DATA_READY       (0x0001)
#define MPU_INT_STATUS_DMP              (0x0002)
#define MPU_INT_STATUS_PLL_READY        (0x0004)
#define MPU_INT_STATUS_I2C_MST          (0x0008)
#define MPU_INT_STATUS_FIFO_OVERFLOW    (0x0010)
#define MPU_INT_STATUS_ZMOT             (0x0020)
#define MPU_INT_STATUS_MOT              (0x0040)
#define MPU_INT_STATUS_FREE_FALL        (0x0080)
#define MPU_INT_STATUS_DMP_0            (0x0100)
#define MPU_INT_STATUS_DMP_1            (0x0200)
#define MPU_INT_STATUS_DMP_2            (0x0400)
#define MPU_INT_STATUS_DMP_3            (0x0800)
#define MPU_INT_STATUS_DMP_4            (0x1000)
#define MPU_INT_STATUS_DMP_5            (0x2000)

#define MPU6050_WHO_AM_I_BIT        6
#define MPU6050_WHO_AM_I_LENGTH     6
#define MPU6050_RA_WHO_AM_I         0x75

class InvMpu
{
    private:
    I2Cdev i2Cdev;
    
    public:
    InvMpu();
    int getDeviceID();
    bool testConnection();
    
    int mpu_reset(void);
    // static
    int set_int_enable(unsigned char enable);
    int get_accel_prod_shift(float *st_shift);
    int accel_self_test(long *bias_regular, long *bias_st);
    int gyro_self_test(long *bias_regular, long *bias_st);
    int compass_self_test(void);
    int get_st_biases(long *gyro, long *accel, unsigned char hw_test);
    int setup_compass(void);
    
    /* Set up APIs */
    int mpu_init(void);
    int mpu_init_slave(void);
    int mpu_set_bypass(unsigned char bypass_on);
    
    /* Configuration APIs */
    int mpu_lp_accel_mode(unsigned char rate);
    int mpu_lp_motion_interrupt(unsigned short thresh, unsigned char time,
        unsigned char lpa_freq);
    int mpu_set_int_level(unsigned char active_low);
    int mpu_set_int_latched(unsigned char enable);
    
    int mpu_set_dmp_state(unsigned char enable);
    int mpu_get_dmp_state(unsigned char *enabled);
    
    int mpu_get_lpf(unsigned short *lpf);
    int mpu_set_lpf(unsigned short lpf);
    
    int mpu_get_gyro_fsr(unsigned short *fsr);
    int mpu_set_gyro_fsr(unsigned short fsr);
    
    int mpu_get_accel_fsr(unsigned char *fsr);
    int mpu_set_accel_fsr(unsigned char fsr);
    
    int mpu_get_compass_fsr(unsigned short *fsr);
    
    int mpu_get_gyro_sens(float *sens);
    int mpu_get_accel_sens(unsigned short *sens);
    
    int mpu_get_sample_rate(unsigned short *rate);
    int mpu_set_sample_rate(unsigned short rate);
    int mpu_get_compass_sample_rate(unsigned short *rate);
    int mpu_set_compass_sample_rate(unsigned short rate);
    
    int mpu_get_fifo_config(unsigned char *sensors);
    int mpu_configure_fifo(unsigned char sensors);
    
    int mpu_get_power_state(unsigned char *power_on);
    int mpu_set_sensors(unsigned char sensors);
    
    int mpu_read_6500_accel_bias(long *accel_bias);
    int mpu_read_6500_gyro_bias(long *gyro_bias);
    int mpu_set_gyro_bias_reg(long * gyro_bias);
    int mpu_set_accel_bias_6500_reg(const long *accel_bias);
    int mpu_read_6050_accel_bias(long *accel_bias);
    int mpu_set_accel_bias_6050_reg(const long *accel_bias);
    
    /* Data getter/setter APIs */
    int mpu_get_gyro_reg(short *data, unsigned long *timestamp);
    int mpu_get_accel_reg(short *data, unsigned long *timestamp);
    int mpu_get_compass_reg(short *data, unsigned long *timestamp);
    int mpu_get_temperature(long *data, unsigned long *timestamp);
    
    int mpu_get_int_status(short *status);
    int mpu_read_fifo(short *gyro, short *accel, unsigned long *timestamp,
        unsigned char *sensors, unsigned char *more);
    int mpu_read_fifo_stream(unsigned short length, unsigned char *data,
        unsigned char *more);
    int mpu_reset_fifo(void);
    
    int mpu_write_mem(unsigned short mem_addr, unsigned short length,
        unsigned char *data);
    int mpu_read_mem(unsigned short mem_addr, unsigned short length,
        unsigned char *data);
    int mpu_load_firmware(unsigned short length, const unsigned char *firmware,
        unsigned short start_addr, unsigned short sample_rate);
    
    int mpu_reg_dump(void);
    int mpu_read_reg(unsigned char reg, unsigned char *data);
    int mpu_run_self_test(long *gyro, long *accel);
    int mpu_run_6500_self_test(long *gyro, long *accel, unsigned char debug);
    int mpu_register_tap_cb(void (*func)(unsigned char, unsigned char));

};


#endif  /* #ifndef _INV_MPU_H_ */