#include <stdio.h>
#include <string.h>
#include "crond.h"

#define CRON_INFO_PATTERN      "%31[-,/*0123456789]"
#define COMMAND_INFO_PATTERN   "%127[^\r\n]"

class CronConfigWork
{
public:
    struct CronConfigBuffer
    {
        static const int MAX_CRON_INFO_LEN = 32;
        char seconds[MAX_CRON_INFO_LEN];
        char minits[MAX_CRON_INFO_LEN];
        char hours[MAX_CRON_INFO_LEN];
        char days[MAX_CRON_INFO_LEN];
        char mounth[MAX_CRON_INFO_LEN];
        char day_of_week[MAX_CRON_INFO_LEN];
    };
    static const int MAX_LINE_LEN = 512;
    static const int MAX_COMMAND_LEN = 128;
    CronTab *tab_lines;
    CronConfigBuffer *config_buffers;
    char line_buffer[MAX_LINE_LEN];
    char command_buffer[MAX_COMMAND_LEN];
    
    CronConfigWork(size_t max_line)
    {
        tab_lines = new CronTab[max_line];
        config_buffers = new CronConfigBuffer[max_line];
    }
    ~CronConfigWork()
    {
        delete[] tab_lines;
        delete[] config_buffers;
    }
};

template <typename TYPE>
bool TabFileLoaderCrond::load_file(const char* cron_config_file_path, size_t max_line, void* info)
{
    static const int CRON_EXPRESSION_NUM = 7;
    crondlog(LVL5 "load user crontab=%s\n", cron_config_file_path);
    FILE *fp = fopen(cron_config_file_path , "r" );
    if (fp == NULL)
    {
        crondlog(ERR20 "user crontab config read error!\n");
        return false;
    }
    else
    {
        CronConfigWork *work = new CronConfigWork(max_line);
        CronTab *tab_lines = work->tab_lines;
        CronConfigWork::CronConfigBuffer *config_buffers = work->config_buffers;
        char* pbuffer = work->line_buffer;
        char* command_buffer = work->command_buffer;
        size_t config_num = 0;
        while( fgets( pbuffer , CronConfigWork::MAX_LINE_LEN , fp ) != NULL )
        {
            // next Line
            if (strchr(pbuffer, '\n') == NULL)
            {
                for(;;)
                {
                    int c = fgetc(fp);
                    if ((c == '\n') || (c == EOF))
                    {
                        break;
                    }
                }
            }
            //comment
            for(int i = 0; (pbuffer[i] != '\0') && (i < CronConfigWork::MAX_LINE_LEN); i++)
            {
                if(pbuffer[i] == '#')
                {
                    pbuffer[i] = '\0';
                    break;
                }
            }
            CronConfigWork::CronConfigBuffer *config_buffer = &config_buffers[config_num];
            int scanret = sscanf(pbuffer, " "
            CRON_INFO_PATTERN " "
            CRON_INFO_PATTERN " "
            CRON_INFO_PATTERN " "
            CRON_INFO_PATTERN " "
            CRON_INFO_PATTERN " "
            CRON_INFO_PATTERN " "
            COMMAND_INFO_PATTERN,
            config_buffer->seconds,
            config_buffer->minits,
            config_buffer->hours,
            config_buffer->days,
            config_buffer->mounth,
            config_buffer->day_of_week,
            command_buffer);
            if (scanret == CRON_EXPRESSION_NUM)
            {
                CronTabExecutable *argument = new TYPE(command_buffer, info);
                crondlog(LVL8 "crontab[%u/%u] seconds=%s, minits=%s hours=%s days=%s mounth=%s day_of_week=%s\n",
                    config_num+1,
                    max_line,
                    config_buffer->seconds,
                    config_buffer->minits,
                    config_buffer->hours,
                    config_buffer->days,
                    config_buffer->mounth,
                    config_buffer->day_of_week
                );
                CronTab& tab_line = tab_lines[config_num];
                tab_line.seconds =     (config_buffer->seconds);
                tab_line.minits =      (config_buffer->minits);
                tab_line.hours =       (config_buffer->hours);
                tab_line.days =        (config_buffer->days);
                tab_line.mounth =      (config_buffer->mounth);
                tab_line.day_of_week = (config_buffer->day_of_week);
                tab_line.exec_func = &TYPE::exec_func;              //int (*exec_func)(void*);
                tab_line.func_arg = (void*)argument;                         //void* func_arg;
                tab_line.wait_func = &TYPE::wait_func;              //int (*wait_func)(int, void*);
                mObjectList.push_back(argument);
                config_num++;
            }
            if (config_num >= max_line)
            {
                break;
            }
        }
        fclose(fp);
        this->add_crontab(cron_config_file_path, tab_lines, config_num);
        delete work;
        crondlog(LVL5 "add crontab %s num=%u\n", cron_config_file_path, config_num);
        return true;
    }
}
