#ifndef CRONTAB_LOADER_H_
#define CRONTAB_LOADER_H_

#include <list>
#include "crond.h"

/**
*
* @class : Cron Tab Execute Class
*
*/
class CronTabExecutable
{
public:
    static int exec_func(void *object)
    {
        CronTabExecutable *self = static_cast<CronTabExecutable*>(object);
        return self->execute();
    }
    static int wait_func(int handle, void* object)
    {
        CronTabExecutable *self = static_cast<CronTabExecutable*>(object);
        return self->wait(handle);
    }

    CronTabExecutable(const char* argument, void* info){ };
    virtual ~CronTabExecutable() { };
    virtual int execute() = 0;
    virtual int wait(int handle)
    {
        return 0;
    }
};



/**
*
* @class : cron Tab File Load
*
*/
class TabFileLoaderCrond : public Crond
{
protected:
    std::list<CronTabExecutable*>  mObjectList;
public:
    static const size_t DEFAULT_MAX_LINE_NUM = 10;
    TabFileLoaderCrond(void (*my_sleep)(int, void*) = NULL, void* tag = NULL) : Crond(my_sleep, tag), mObjectList() { };
    virtual ~TabFileLoaderCrond()
    {
        for(std::list<CronTabExecutable*>::iterator i = mObjectList.begin(); i != mObjectList.end(); ++i)
        {
            delete *i;
        }
    }
    template <typename TYPE>
    bool load_file(const char* cron_config_file_path, size_t max_line = DEFAULT_MAX_LINE_NUM, void* info = NULL);
};

#include "TabFileLoaderCrond.hpp"

#endif
