#include <string.h>
#include <stdio.h>
#include <stdarg.h>
#include "RPCCommandList.h"
#include "crond_config.h"

RPCCommandList::RPCCommandList(const char *scripts, char delimiter) : m_commands(NULL), m_length(0)
{
    m_command_buffer = new char[strlen(scripts) + 1];
    strcpy(m_command_buffer, scripts);
    create_command_list(m_command_buffer, delimiter);
}

RPCCommandList::~RPCCommandList()
{
    delete[] m_commands;
    delete[] m_command_buffer;
}

void RPCCommandList::log(const char *ctl, ...)
{
    char level = ctl[0];
    va_list arglist;
    va_start(arglist, ctl);
    CRON_VPRINTF(level, &ctl[1], arglist);
    va_end(arglist);
    return;
}

int RPCCommandList::length(void)
{
    return m_length;
}

char** RPCCommandList::commands(void)
{
    return m_commands;
}

void RPCCommandList::create_command_list(char* script, char delimiter)
{
    int count_delim = 0;
    char delimiter_str[] = { delimiter, '\0' };
    for(int i= 0; script[i] != '\0'; i++)
    {
        if (script[i] == delimiter)
        {
            count_delim++;
        }
    }
    if ((*this).m_commands != NULL)
    {
        delete[] (*this).m_commands;
    }
    (*this).m_commands = new char*[(count_delim + 2)];
    char** commands_indexer = (*this).m_commands;
    (*this).m_length = count_delim+1;
    log(LVL5 "RPCCommands command num=%d\n", (*this).m_length);
    if (count_delim > 0)
    {
        char *brkt = NULL;
        char *tp = strtok_r( script, delimiter_str, &brkt );
        if ( tp != NULL )
        {
            *commands_indexer = tp;
             log(LVL5 "RPCCommands command[%u]=%s\n", (commands_indexer-(*this).m_commands), *commands_indexer);
            commands_indexer++;
            while ( tp != NULL )
            {
                tp = strtok_r( NULL, delimiter_str, &brkt);
                if ( tp != NULL )
                {
                    *commands_indexer = tp;
                     log(LVL5 "RPCCommands command[%u]=%s\n", (commands_indexer-(*this).m_commands), *commands_indexer);
                    commands_indexer++;
                }
            }
        }
        else
        {
            *commands_indexer = script;
             log(LVL5 "RPCCommands command[%u]=%s\n", (commands_indexer-(*this).m_commands), *commands_indexer);
        }
    }
    else
    {
        *commands_indexer = script;
         log(LVL5 "RPCCommands command[%u]=%s\n", (commands_indexer-(*this).m_commands), *commands_indexer);
    }
}

int RPCCommandList::execute(RPC &rpc)
{
    char buffer[RPC_MAX_STRING+1];
    log(LVL5 "RPC command start\n");
    for(int idx = 0; idx < m_length; idx++)
    {
        const char *cmdlines = m_commands[idx];
        memset(buffer, 0, sizeof(buffer));
        log(LVL5 "RPC call exec [%s]\n", cmdlines);
        if (rpc.call(cmdlines, buffer))
        {
            buffer[RPC_MAX_STRING] = '\0';
            log(LVL5 "RPC call result [%s]\n", buffer);
        }
        else
        {
            log(WARN9 "RPC call error! exec=[%s]\n", cmdlines);
        }
    }
    log(LVL5 "RPC command end\n");
    return 0;
}
