#pragma once
#ifndef CROND_H_
#define CROND_H_
#include <time.h>

/* 0 is the most verbose, default 8 */
#define LVL5  "\x05"
#define LVL7  "\x07"
#define LVL8  "\x08"
#define WARN9 "\x49"
#define DIE9  "\xc9"
/* level >= 20 is "error" */
#define ERR20 "\x14"

typedef struct CronTab {
	char* seconds;
	char* minits;
	char* hours;
	char* days;
	char* mounth;
	char* day_of_week;
	int (*exec_func)(void*);
	void* func_arg;
	int (*wait_func)(int, void*);
} CronTab;

typedef struct CronFile {
	struct CronFile *cf_next;
	struct CronLine *cf_lines;
	char *cf_crontabset_name;
	char cf_wants_starting;     /* bool: one or more jobs ready */
	char cf_has_running;        /* bool: one or more jobs running */
	char cf_deleted;            /* marked for deletion (but still has running jobs) */
} CronFile;

typedef struct CronLine {
	struct CronLine *cl_next;
	int (*cl_exec_func)(void*);                   /* functon (return <=0:end job, >0:ansync pid, */
	int (*cl_wait_func)(int, void*);
	void *cl_func_arg;
	int cl_pid;                   /* >0:running, <0:needs to be started in this minute, 0:dormant */
	/* ordered by size, not in natural order. makes code smaller: */
	char cl_Dow[7];                 /* 0-6, beginning sunday */
	char cl_Mons[12];               /* 0-11 */
	char cl_Hrs[24];                /* 0-23 */
	char cl_Days[32];               /* 1-31 */
	char cl_Mins[60];               /* 0-59 */
	char cl_Secs[60];               /* 0-59 */
} CronLine;

typedef enum CrondStatus {
	RUNNING,
	STOPPING
} CrondStatus;

class Crond
{
protected:
	CronFile *cron_files;
	void (*sleep)(int, void*);
	void *sleep_tag;
	volatile CrondStatus status;

	void crondlog(const char *ctl, ...);
	void parse_field(char *user, char *ary, int modvalue, int off,
					const char *names, char *ptr);
	void fix_day_dow(CronLine *line);
	void start_one_job(CronLine *line);
	void flag_starting_jobs(time_t t1, time_t t2);
	void start_jobs(void);
	int check_completions(void);

public:
	/**
	* debug log level (default = 8)
	*/
	unsigned log_level;
    /**
    * @brief Initialized by loading the configuration from a file.
    * @param[in] my_sleep : sleep function pointer
    * @param[in] tag : sleep function parameter
    */
	Crond(void (*my_sleep)(int, void*) = NULL, void* tag = NULL);
	virtual ~Crond();
	int add_crontab(const char* crontabset_name, const CronTab crontab[], int length);
	void delete_crontab(const char *crontabset_name);
	int length(void);
	const char* get_crontab_name(int idx);
	int start(void);
	void stop(void);
};

#endif

