#ifndef RPC_CROND_H
#define RPC_CROND_H

#include "rpc.h"
#include "TabFileLoaderCrond.h"
#include "RPCCommandList.h"

class RpcCronTabExecutable : public CronTabExecutable
{
private:

    RPCCommandList *m_commands;
    RPC &m_rpc;
public:
    RpcCronTabExecutable(const char* argument, void* info) : CronTabExecutable(argument, info), m_commands(new RPCCommandList(argument)), m_rpc(*static_cast<RPC*>(info))
    { }
    virtual ~RpcCronTabExecutable()
    {
        delete m_commands;
    }
    virtual int execute()
    {
        return m_commands->execute(m_rpc);
    }
};

class RpcCrond : public TabFileLoaderCrond
{
    typedef TabFileLoaderCrond Base;
public:
    RpcCrond(void (*my_sleep)(int, void*) = NULL, void* tag = NULL) : TabFileLoaderCrond(my_sleep, tag)
    { }
    bool load_file(const char* cron_config_file_path, size_t max_line, RPC &rpc)
    {
        return Base::load_file<RpcCronTabExecutable>(cron_config_file_path, max_line, &rpc);
    }
};

#endif
