#include "mbed.h"

#include "E36obd.h"

Serial dbg(USBTX, USBRX);

int main()
{
    //dbg.baud(115200);
    
    //the DS2 class will need two bus objects for TXD (K bus) and RXD (L bus)
    //the Bus class derives from the mbed Serial class and each needs a tx/rx pair of serial pins
    //4 pins total are used in this implementation (2 serial port peripherals)
    Bus* k_line = new Bus(p9, p10);
    Bus* l_line = new Bus(p13, p14);
    DS2 ds2(k_line, l_line);
    
    //we can run some basic tests on the interface
    //if they fail, check the source to see how
    if(!k_line->test())
        printf("k_line test failed - check interface hardware\r\n");
    if(!l_line->test())
        printf("l_line test failed - check interface hardware\r\n");
    if(!ds2.test())
        printf("ds2 test failed\r\n");
    //nothing below will work if these failed
    
    //DS2::testModule will attempt to raise a module by address
    //in much the same way that INPA does
    int address = 0x00; //zke4
    ds2.testModule(address);
    
    //more modules - some have multiple addresses to try
    ds2.testModule(0x80); //kombi
    ds2.testModule(0x0d); //kombi
    ds2.testModule(0x59); //ihkr
    ds2.testModule(0x5b); //ihka
    ds2.testModule(0x36); //mk4
    ds2.testModule(0x56); //mk20
    ds2.testModule(0xcd); //obc
    ds2.testModule(0xa4); //srs
    ds2.testModule(0x44); //ews
    ds2.testModule(0x60); //pdc
    ds2.testModule(0x12); //dme4
    
    printf("done querying modules\r\n");
    
    //here we can snoop inpa traffic and print it to dbg
    //this will never return
    ds2.snoop();
    

}
