#include "Bus.h"

Bus::Bus(PinName tx, PinName rx) :
    Serial(tx, rx)
{
    txPin = tx;
    rxPin = rx;
}

//send data out to the bus and make sure the echo comes back ok
int Bus::send(char* data, int length)
{
    int count = 0;
    while(length--)
    {
        while(!writeable());
        putc(*data);
        
        //wait for the echo and verify it
        int timeout;
        for(timeout = 10000; timeout; timeout--)
        {
            if(!readable())
                continue;
            char c = getc();
            if(c != *data)
                dbg.printf("interface error/collision: %x != %x\r\n", c, *data);
            break;
        }
        if(!timeout)
            dbg.printf("echo timeout - check interface hardware\r\n");
            
        data++;
        count++;
        //might need to sleep between bytes for some modules (abs?)
    }
    return count;
}

//gets everything in the uart buffer
int Bus::get(char* data, int length)
{
    int count = 0;
    while(readable() && length--)
    {
        *data++ = getc();
        count++;
    }
    return count;
}

//verify that we can assert the bus
//a failure here almost certainly points to a problem with the mbed-vehicle interface circuitry
//this should pass regardless of whether the interface is connected to the vehicle bus
bool Bus::test()
{
    //write some data to the bus
    while(!writeable());
    putc(0x55);
    
    //wait for the echo and verify it
    int timeout;
    for(timeout = 10000; timeout; timeout--)
    {
        if(!readable())
            continue;
        char c = getc();
        if(c == 0x55)
            return 1;
    }
    return 0;
}
