#ifndef LSM9DS0_SH_H
#define LSM9DS0_SH_H

#include "mbed.h"

// Personality of IMU //
#define Gpx 3.068e-4f       //1.526e-2 * d2r = 2.663e-4f
#define Gpy 3.064e-4f       //1.526e-2 * d2r = 2.663e-4f
#define Gpz 2.994e-4f       //1.526e-2 * d2r = 2.663e-4f
//#define Gdx -0.0099f      //initial nutraulize
//#define Gdy 0.0168f
//#define Gdz 0.0210f

#define Apx -1.239e-4f      //one for G
#define Apy -1.234e-4f
#define Apz -1.236e-4f
//#define Adx -0.1460f
//#define Ady -0.0695f
//#define Adz -0.0228f

// LSM9DS0 Gyro Registers //
#define WHO_AM_I_G          0x0F    //r     //WHO_G
#define CTRL_REG1_G         0x20    //rw    //GYRO Data-rate/LPF/Enable
#define CTRL_REG2_G         0x21    //rw
#define CTRL_REG3_G         0x22    //rw
#define CTRL_REG4_G         0x23    //rw    //GYRO Scale
#define CTRL_REG5_G         0x24    //rw
#define REFERENCE_G         0x25    //rw
#define STATUS_REG_G        0x27    //r
#define OUT_X_L_G           0x28    //r     //GYRO Data
#define OUT_X_H_G           0x29    //r     //GYRO Data
#define OUT_Y_L_G           0x2A    //r     //GYRO Data
#define OUT_Y_H_G           0x2B    //r     //GYRO Data
#define OUT_Z_L_G           0x2C    //r     //GYRO Data
#define OUT_Z_H_G           0x2D    //r     //GYRO Data

// LSM9DS0 Accel/Magneto (XM) Registers //
#define OUT_TEMP_L_XM       0x05    //r     //TEMP Data
#define OUT_TEMP_H_XM       0x06    //r     //TEMP Data
#define STATUS_REG_M        0x07    //r
#define OUT_X_L_M           0x08    //r     //MAG Data
#define OUT_X_H_M           0x09    //r     //MAG Data
#define OUT_Y_L_M           0x0A    //r     //MAG Data
#define OUT_Y_H_M           0x0B    //r     //MAG Data
#define OUT_Z_L_M           0x0C    //r     //MAG Data
#define OUT_Z_H_M           0x0D    //r     //MAG Data
#define WHO_AM_I_XM         0x0F    //r     //WHO_XM
#define OFFSET_X_L_M        0x16    //rw    //MAG Data_Offset
#define OFFSET_X_H_M        0x17    //rw    //MAG Data_Offset
#define OFFSET_Y_L_M        0x18    //rw    //MAG Data_Offset
#define OFFSET_Y_H_M        0x19    //rw    //MAG Data_Offset
#define OFFSET_Z_L_M        0x1A    //rw    //MAG Data_Offset
#define OFFSET_Z_H_M        0x1B    //rw    //MAG Data_Offset
#define CTRL_REG0_XM        0x1F    //rw
#define CTRL_REG1_XM        0x20    //rw    //ACC Data-rate/Enable
#define CTRL_REG2_XM        0x21    //rw    //ACC LPF/Scale
#define CTRL_REG3_XM        0x22    //rw
#define CTRL_REG4_XM        0x23    //rw
#define CTRL_REG5_XM        0x24    //rw    //TEMP Enable, MAG Data-rate
#define CTRL_REG6_XM        0x25    //rw    //MAG Scale
#define CTRL_REG7_XM        0x26    //rw
#define STATUS_REG_A        0x27    //r
#define OUT_X_L_A           0x28    //r     //ACC Data
#define OUT_X_H_A           0x29    //r     //ACC Data
#define OUT_Y_L_A           0x2A    //r     //ACC Data
#define OUT_Y_H_A           0x2B    //r     //ACC Data
#define OUT_Z_L_A           0x2C    //r     //ACC Data
#define OUT_Z_H_A           0x2D    //r     //ACC Data


#endif  //LSM9DS0_SH_H