#include "mbed.h"

#define MLX90614_ADDR   (0x5A)          // Slave address
#define MLX90614_TOBJ   (0x07)          // Object temperature register

//~~~~~~~~~~~~~~~~~~~~~~~~~~~GPIO registor~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
//~~~structure~~~//
DigitalOut  led(D13);                   //link leg

//~~~Sensor_I2C~~~//
I2C         i2c(D14, D15);              //I2C reg(SDA, SCL)

//~~~Serial~~~//
Serial      pc(D1, D0);                 //Serial reg
//~~~~~~~~~~~~~~~~~~~~~~~~~~~end of GPIO registor~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//


//~~~~~~~~~~~~~~~~~~~~~~~~~~~Varible registor~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
//~~~globle~~~//
Ticker  TT;                             //call a timer

//~~~Sensor_I2C~~~//
char    data_write[1];                  //buff for write
char    data_read [3];                  //buff for read
short   Buff = 0x00;
float   TOBJ = 0.0;
//~~~~~~~~~~~~~~~~~~~~~~~~~~~end of Varible registor~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//


//~~~~~~~~~~~~~~~~~~~~~~~~~~~Function registor~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
void    init_IO();                     //initialize IO state
void    init_TIMER();                  //set TT_main{} rate
void    TT_main();                     //timebase function rated by TT
void    read_MLX();                    //read MLX data give raw data
//~~~~~~~~~~~~~~~~~~~~~~~~~~~end of Function registor~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//


//~~~~~~~~~~~~~~~~~~~~~~~~~~~main funtion~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
int main()
{
    init_IO();                          //initialized value and IRQ(Interrupt request)
    init_TIMER();                       //start TT_main
    
    while(1) {                          //main() loop
    }

}
//~~~~~~~~~~~~~~~~~~~~~~~~~~~end of main funtion~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//


//~~~~~~~~~~~~~~~~~~~~~~~~~~~init_IO funtion~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
void init_IO(void)                      //initialize
{
    led = 0;
    pc.baud(9600);                      //set baud rate
    i2c.frequency(100000);              //100kHz
//    NVIC_SetPriority(I2C1_ER_IRQn, 0);  //!!!!!!!!!!!!!!!!!!!!!!!!!
//    NVIC_SetPriority(I2C1_EV_IRQn, 0);  //!!!!!!!!!!!!!!!!!!!!!!!!!
    NVIC_SetPriority(TIM5_IRQn, 51);    //!!!!!!!!!!!!!!!!!!!!!!!!!
}
//~~~~~~~~~~~~~~~~~~~~~~~~~~~end of init_IO funtion~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//


//~~~~~~~~~~~~~~~~~~~~~~~~~~~Timebase funtion~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
void init_TIMER()                       //set TT_main{} rate
{
    TT.attach_us(&TT_main, 10000);      //rate set to 100Hz
}

void TT_main()                          //interrupt function by TT
{
    read_MLX();                         //update MLX data
    TOBJ = ((float)Buff * 0.02f) - 273.0f;
    printf("%.2f\n",TOBJ);
}
//~~~~~~~~~~~~~~~~~~~~~~~~~~~end of Timebase funtion~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//



//↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓read_IMU funtion↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓//
void read_MLX(void)                     //read MLX data give raw data
{
    //TOBJ
    data_write[0] = MLX90614_TOBJ;      //TOBJ address to buff
    i2c.write( MLX90614_ADDR<<1 | 0x00, data_write, 1, 1);  //command to RAM access
    i2c.read ( MLX90614_ADDR<<1 | 0x01, data_read , 3, 0);  //read callback
    Buff = data_read[1] << 8 |data_read[0];
}
//↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑end of read_IMU funtion↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑//