#include "mbed.h"

#define MLX90614_ADDR   (0x5A)          // Slave address
#define MLX90614_TOBJ   (0x07)          // Object temperature register

DigitalOut  led(D13);                   //link leg
I2C         i2c(D14, D15);              //I2C reg(SDA, SCL)
Serial      pc(D1, D0);                 //Serial reg
Ticker      TT;                             //call a timer

char    data_write[1];                  //buff for write
char    data_read [3];                  //buff for read
short   Buff = 0x00;
float   TOBJ = 0.0;
void    read_MLX();

int main()
{
    led = 0;
    pc.baud(9600);                      //set baud rate
    i2c.frequency(100000);              //100kHz
    read_MLX();                         //update MLX data
    TOBJ = ((float)Buff * 0.02f) - 273.0f;
    printf("%.2f\n",TOBJ);
}


void read_MLX(void)                     //read MLX data give raw data
{
    led = 1;
    //TOBJ
    data_write[0] = MLX90614_TOBJ;      //TOBJ address to buff
    i2c.write( MLX90614_ADDR<<1 | 0x00, data_write, 1, 1);  //command to RAM access SR activated
    i2c.read ( MLX90614_ADDR<<1 | 0x01, data_read , 3, 0);  //read callback
    Buff  =  data_read[1] << 8;         // merging
    Buff |=  data_read[0];
    led = 0;
}