/*
This is a example program for using CAN Bus protocol.
Feel free to modified to your own usage.
The function include:

1.  Interrupt-type recieving program
    A better method to cover the small mailbox size limited by hardware ( = 3 )
    Might overload the CPU when Bus jammed ( >50% Bus load )
    Might occur during any part of main function, so a proper buffering should apply
    ( Avoid any varible directly change by intterupt, use a buffer and/or flags instead )

2.  A TX flag which decide whether a message is broadcast on the CAN Bus
    "Charge OK" signal (Sent on CAN Bus frequently, if a charging manager is online, it will start charging the cells.)

3.  A "Heart-Beat" flag which can stop specific action if specified message absence from CAN Bus
    "Balance OK" signal (Sent from charging manager, dedicate the charging condition. In driving condition, no balance is allowed.)
*/


#include "mbed.h"

CAN can1(PB_5, PB_13, 1000000);                     //Declare a CAN object

CANMessage can_msg_1;                               //Use as general beffer
CANMessage can_msg_send;                            //Use as general buffer (Sent out)

uint8_t CAN_flag_TX = 0;                            //Flag for sending out shit

uint8_t CAN_flag_RX = 0;                            //Flag when recieving shit

uint8_t CAN_flag_HeartBeat = 0;                     //Flag if a heart beat signal is require for certain action

uint8_t Buffer_RX = 0;                              //Genral buffer, can derictly change by interrupt, might change during mian()
uint8_t Data_RX = 0;                                //Genral buffer, only change if condition met, keep as a constant threw whole main()

char data_msg[8] = {0,0,0,0,0,0,0,0};               //Example varible which might change by CAN message

void CAN1_RX(void);                                 //Interrupt type recieving program



int main()
{
    CAN_flag_TX = 0;                                //Reset flags
    CAN_flag_RX = 0;

    can1.attach(&CAN1_RX, CAN::RxIrq);              //Start CAN1 Recieve Irq

    while(1) {
        //Transfer data from voltile varible to normal varible ( avoid change during main() )
        while(CAN_flag_RX == 1) {                   //Check if varible updated (Recieve new)
            Data_RX = Buffer_RX;                    //Transfering
            CAN_flag_RX = 0;                        //Reset flag
        }

        /*
         *General Program
         *
         *data_msg[i] = something;                  //General calculation
         *
         *if(CAN_flag_HeartBeat == 1){
         *  Do something when heart beat signal arrive
         *  CAN_flag_HeartBeat = 0;                 //Reset flag
         *  }
         *
         *CAN_flag_TX = 1;                          //If some condition met or need to sned out some message
         */

        while(CAN_flag_TX == 1) {
            can_msg_send = CANMessage(0xFA,data_msg,8,CANData,CANStandard);     //Send out data_msg with ID = 0xFA
            can1.write(can_msg_send);                                           
            CAN_flag_TX = 0;                                                    //Reset flag
        }
    }
}

void CAN1_RX(void)
{
    if(can1.read(can_msg_1)) {                                              //If a false interrupt then do nothing
        switch(can_msg.id) {                                                //Filtered the input message and do corresponding action
            case 0xA2 :                                                     //Just an arbitary ID
                Buffer_RX = can_msg_1.data[5] << 8 | can_msg_1.data[4];     //Transfer data from can_msg_1 to target varible
                CAN_flag_RX = 1;                                            //Flag if needed, in this case indicate a new varible arrived
                /*
                if(some bits or similar == shit) {
                    CAN_flag_HeartBeat = 1;                                 //Set up a heart beat flag
                }
                */
                break;

//          case 0xAB :                                                     //Add more if needed
//              for(int i=0; i<8; i++) {
//                  Fault[i] = can_msg.data[i];
//              }
//              Fault_M = Fault[0] | Fault[1] | Fault[2] | Fault[3] | Fault[4] | Fault[5] | Fault[6] | Fault[7];
//              printflag = 1;
//              break;
        }
    }
}