#include "mbed.h"
#include "A1333_PoOPoO.h"

#define pi 3.141592f
#define d2r 0.01745329f
#define NN  1
#define Rms 1000000             // TT rate

//choose if write in configurations
#define WRCONFIG    1           // 1 to write in configurations

//choose if A1339 extended settings
#define A1339EXT    0           // 1 to enable A1339 extended settings

//↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓GPIO registor↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓//
//~~~structure~~~//
DigitalOut  led(D13);           //detection
DigitalOut  TT_ext(D12);

//~~~SPI~~~//
DigitalOut  spi_CS(D6,1);       //low for ACC/MAG enable
SPI spi(D4, D5, D3);            //MOSI MISO SCLK

//~~~Serial~~~//
Serial      pc(D1, D0);         //Serial reg(TX RX)
//↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑end of GPIO registor↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑//



//↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓Varible registor↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓//
//~~~globle~~~//
Ticker  TT;                         //call a timer
int Count = 0;                      //one second counter for extrenal led blink

//~~~A1333_data~~~//

//↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑end of Varible registor↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑//



//↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓Function registor↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓//
void    init_TIMER();           //set TT_main() rate
void    TT_main();              //timebase function rated by TT
void    init_IO();              //initialize IO state
void    A1333_init();           //initialize shit
void    A1333_reset();          //restart target
void    A1333_getstate();       //get current state & errors
void    A1333_ulkEEPROM();      //unlock protection of EEPROM
void    A1333_getEEP(int X_E);  //read EEPROM of X_E
void    A1333_writeEEP(int X_E, int32_t DataH, int32_t DataL);  //write EEPROM of X_E

//↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑end of Function registor↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑//



//↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓main funtion↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓//
int main()
{
    init_IO();                  //initialized value
    A1333_init();

    pc.printf("\n\n");
    pc.printf("Welcome to A1333/A1339 configurator\n");
    pc.printf("Resetting target...\n");
    A1333_reset();
    wait_ms(200);

#if A1339EXT
    pc.printf("A1339 extended settings are enable!\n");
#endif

    A1333_getstate();
    pc.printf("\n");

    pc.printf("Read PWE_E\n");  //Doesnt matter for us
    A1333_getEEP(PWE_E);
    pc.printf("\n");

    pc.printf("Read ABI_E\n");  //Need to be set for application!!
    A1333_getEEP(ABI_E);
    pc.printf("\n");

    pc.printf("Read MSK_E\n");  //Doesnt matter for us
    A1333_getEEP(MSK_E);
    pc.printf("\n");

    pc.printf("Read PWI_E\n");  //Doesnt matter for us
    A1333_getEEP(PWI_E);
    pc.printf("\n");

    pc.printf("Read ANG_E\n");
    A1333_getEEP(ANG_E);
    pc.printf("\n");

    pc.printf("Read LPC_E\n");
    A1333_getEEP(LPC_E);
    pc.printf("\n");

    pc.printf("Read COM_E\n");
    A1333_getEEP(COM_E);
    pc.printf("\n");

    // A1333/A1339 require unlock before eeprom access
    A1333_ulkEEPROM();
    pc.printf("\n");

#if WRCONFIG
    pc.printf("Start writting configurations!\n");

    /* Configuration sectionfor ABI_EEPROM settings "A1333/A1339"
    ABI_SLEW_TIME, INV,  AHE,  INDEX_MODE, WDH, PLH, IOE, UVW, RESOLUTION_PAIRS,
    [21:16],       [15], [12], [9:8],      [7], [6], [5], [4], [3:0],
    00000001,      0,    1,    0,          1,   1,   1,   0,   0100,
    250ns          no,   yes,  0+R,        yes, yes, yes, ABI, 1024pulse/mechRev,(Notice ABx4 res is *4 at last)
    result to 0x0001, 0x10E4
    Run follow to write in */
    A1333_writeEEP(ABI_E, 0x01, 0x10E4);
    pc.printf("ABI_E write done\n");
    pc.printf("\n");

    /* Configuration sectionfor PWI_EEPROM settings "A1333/A1339"
    PEN,  BAND,    FREQ,    PHE,  PEO,  PES,  DM,  S17, SC,
    [23], [22:20], [19:16], [14], [13], [12], [3], [1], [0],
    1,    0,       0,       0,    0,    0,    0,   0,   0,
    yes,  3125Hz,           no,   no,   no,   no,  no,  no,
    result to 0x0080, 0x0000
    Run follow to write in */
    A1333_writeEEP(PWI_E, 0x80, 0x0000);
    pc.printf("PWI_E write done\n");
    pc.printf("\n");

    /* Configuration sectionfor ANG_EEPROM settings "A1333/A1339"
    ORATE,   RD,   RO,        HYSTERESIS,  ZERO_OFFSET,
    [23:20], [19], [18],      [17:12],     [11:0],
    0000,    0,    0,         101000,      0x000-0x3FF,
    1us,     no,   direction, 20/16383rev, Calibrate in DSM instead,
    result to 0x0002, 0x8000
    Run follow to write in */
    A1333_writeEEP(ANG_E, 0x02, 0x8000);
    pc.printf("ANG_E write done\n");
    pc.printf("\n");

#if A1339EXT
    /* Configuration sectionfor LPC_EEPROM settings "A1339 only"
    T45,     TPMD, LPMD, LPM_CYCLE_TIME, LPM_WAKE_THRESHOLD,
    [23],    [21], [20], [17:12],        [10:0],
    1,       1,    1,    001011,         01010011111,
    default, no,   no,   default,        default,
    result to 0x00B0, 0xB29F
    Run follow to write in */
    A1333_writeEEP(LPC_E, 0xB0, 0xB29F);    //A1339 only
    pc.printf("LPC_E write done\n");
    pc.printf("\n");
#endif  //A1339EXT

    /* Configuration sectionfor COM_EEPROM settings "A1333/A1339"
    LOCK,    LBE,  CSE,  DST,  DHR,  MAG_THRES_HI, MAG_THRES_LO,
    [23:20], [19], [18], [13], [12], [11:6],       [5:0],
    0000,    1,    1,    0,    0,    100101,       001101,
    no,      yes,  yes,  no,   no,   default,      default,
    result to 0x000C, 0x094D
    Run follow to write in */
    A1333_writeEEP(COM_E, 0x0C, 0x094D);
    pc.printf("COM_E write done\n");
    pc.printf("\n");

#endif  //WRCONFIG

    pc.printf("End of A1333/A1339 configurator\n");

    init_TIMER();               //start TT_main

    while(1) {                  //main() loop
        if(Count >= NN) {       //check if main working
            Count=0;
            led = !led;
        }
    }
}


void init_TIMER()                   //set TT_main{} rate
{
    TT.attach_us(&TT_main, Rms);
}


void TT_main()                      //interrupt function by TT
{
    TT_ext = !TT_ext;               //indicate TT_main() function working
    Count = Count+1;                //one second counter
}


void init_IO(void)                  //initialize
{
    pc.baud(115200);                //set baud rate
    TT_ext = 0;
    led = 1;
}


void A1333_init(void)               //initialize
{
    //gloable config
    spi_CS = 1;                     //high as init for disable SPI

    spi.format(16, 3);              //byte width, spi mode
    spi.frequency(1000000);         //8MHz
}

void A1333_reset(void)              //restart target
{
    // write in special
    spi_CS = 0;
    spi.write( (((CTRL|WMASK)<<8U)&0xFF00) | 0b111 );   //CTRL.SPECIAL <= 0b111
    spi_CS = 1;
    // write in INITIATE_SPECIAL
    spi_CS = 0;
    spi.write( ((((CTRL+1U)|WMASK)<<8U)&0xFF00) | 0x5A );   //CTRL.INITIATE_SPECIAL <= 0x5A
    spi_CS = 1;
}

void A1333_writeEEP(int X_E, int32_t DataH, int32_t DataL)
{
    uint16_t tmp;

//Read EEPROM of X_E
    //Prepare eeprom
    spi_CS = 0;
    spi.write( ((((EWA+1U)|WMASK)<<8U)&0xFF00) | X_E );
    spi_CS = 1;
//Push in data
    spi_CS = 0;
    spi.write( (((EWDH|WMASK)<<8U)&0xFF00) | ((DataH>>8U)&0xFF) );
    spi_CS = 1;
    spi_CS = 0;
    spi.write( ((((EWDH+1U)|WMASK)<<8U)&0xFF00) | (DataH&0xFF) );
    spi_CS = 1;
    spi_CS = 0;
    spi.write( (((EWDL|WMASK)<<8U)&0xFF00) | ((DataL>>8U)&0xFF) );
    spi_CS = 1;
    spi_CS = 0;
    spi.write( ((((EWDL+1U)|WMASK)<<8U)&0xFF00) | (DataL&0xFF) );
    spi_CS = 1;

//Start EEP writing
    spi_CS = 0;
    spi.write( (((EWCS|WMASK)<<8U)&0xFF00) | 0x80 );
    spi_CS = 1;
    tmp = 0x0000;
    while((tmp & 0x0001) != 0x0001) {
        spi_CS = 0;
        spi.write( (EWCS << 8U) & 0xFF00 );
        spi_CS = 1;
        spi_CS = 0;
        tmp = spi.write(0x0000);
        spi_CS = 1;
    }
}

void A1333_getstate(void)               //read IMU data give raw data
{
    uint16_t tmp;

    //Read temperature as state check
    spi_CS = 0;                         //start spi talking
    spi.write( (TSEN << 8U) & 0xFF00 ); //read mask: RMASK = 0, no need
    spi_CS = 1;
    spi_CS = 0;
    tmp = spi.write(0x0000);
    spi_CS = 1;                         //end spi talking
    if ((tmp & 0xF000) != 0xF000) {
        pc.printf("Temperature read id mismatch\n");
    } else {
        pc.printf("TSEN is: %04X\n", tmp);
        int16_t tmps = tmp<<4;
        float tmpf = tmps/64.0f + 25.0f;
        pc.printf("Temperature is: %.2f\n", tmpf);
    }

    //Read error check
    spi_CS = 0;                         //start spi talking Wx
    spi.write( (ERR << 8U) & 0xFF00 );
    spi_CS = 1;
    spi_CS = 0;
    tmp = spi.write(0x0000);
    spi_CS = 1;                         //end spi talking
    if ((tmp & 0xF000) != 0xA000) {
        pc.printf("Error read id mismatch\n");
    } else {
        pc.printf("ERR is: %04X\n", tmp);
    }

    //Read status check
    spi_CS = 0;                    //start spi talking Wx
    spi.write( (STA << 8U) & 0xFF00 );
    spi_CS = 1;
    spi_CS = 0;
    tmp = spi.write(0x0000);
    spi_CS = 1;                    //end spi talking
    if ((tmp & 0xF000) != 0x8000) {
        pc.printf("State read id mismatch\n");
    } else {
        pc.printf("STA is: %04X\n", tmp);
    }
}

void A1333_ulkEEPROM(void)
{
    uint16_t tmp;

    //read key lock
    spi_CS = 0;                    //start spi talking Wx
    spi.write( (IKEY << 8U) & 0xFF00 );
    spi_CS = 1;
    spi_CS = 0;
    tmp = spi.write(0x0000);
    spi_CS = 1;
    pc.printf("IKEY before unlock is: %04X\n", tmp);

    //Now try to unlock EEPROM write
    //write in key
    spi_CS = 0;
    spi.write( (((IKEY|WMASK)<<8U)&0xFF00) | 0x00 );
    spi_CS = 1;
    spi_CS = 0;
    spi.write( (((IKEY|WMASK)<<8U)&0xFF00) | 0x27 );
    spi_CS = 1;
    spi_CS = 0;
    spi.write( (((IKEY|WMASK)<<8U)&0xFF00) | 0x81 );
    spi_CS = 1;
    spi_CS = 0;
    spi.write( (((IKEY|WMASK)<<8U)&0xFF00) | 0x1F );
    spi_CS = 1;
    spi_CS = 0;
    spi.write( (((IKEY|WMASK)<<8U)&0xFF00) | 0x77 );
    spi_CS = 1;

    //read key lock again after unlock
    spi_CS = 0;                    //start spi talking Wx
    spi.write( (IKEY << 8U) & 0xFF00 );
    spi_CS = 1;
    spi_CS = 0;
    tmp = spi.write(0x0000);
    spi_CS = 1;
    pc.printf("IKEY is: %04X\n", tmp);
    if ((tmp & 0x00FF) != 0x0001) {
        pc.printf("Device fail to unlock\n");
    } else {
        pc.printf("Device unlocked\n");
    }
}

void A1333_getEEP(int X_E)
{
    uint16_t tmp;

    //Read eeprom
    spi_CS = 0;
    spi.write( ((((ERA+1U)|WMASK)<<8U)&0xFF00) | X_E );
    spi_CS = 1;
    spi_CS = 0;
    spi.write( (((ERCS|WMASK)<<8U)&0xFF00) | 0x80 );
    spi_CS = 1;
    tmp = 0x0000;
    while((tmp & 0x0001) != 0x0001) {
        spi_CS = 0;
        spi.write( (ERCS << 8U) & 0xFF00 );
        spi_CS = 1;
        spi_CS = 0;
        tmp = spi.write(0x0000);
        spi_CS = 1;
    }
    spi_CS = 0;
    spi.write( (ERDH << 8U) & 0xFF00 );
    spi_CS = 1;
    spi_CS = 0;
    tmp = spi.write( (ERDL << 8U) & 0xFF00 ) & 0xFF;
    spi_CS = 1;
    pc.printf("ERDH/ERDL: %02X", tmp);

    spi_CS = 0;
    tmp = spi.write(0x0000);
    spi_CS = 1;
    pc.printf("%04X\n", tmp);
}