#ifndef A1333_PoOPoO_H
#define A1333_PoOPoO_H

// A1333 Serial command Registers //

#define WMASK               0x40    // write mask
#define RMASK               0x00    // read mask

#define EWA                 0x02    //r/w
#define EWDH                0x04    //r/w
#define EWDL                0x06    //r/w
#define EWCS                0x08    //ro/wo
#define ERA                 0x0A    //r/w
#define ERCS                0x0C    //ro/wo
#define ERDH                0x0E    //r/w
#define ERDL                0x10    //r/w

#define CTRL                0x1E    //rw/wo
#define ANG                 0x20    //ro
#define STA                 0x22    //ro
#define ERR                 0x24    //ro
#define WARN                0x26    //ro
#define TSEN                0x28    //ro
#define FIELD               0x2A    //ro
#define TURNS               0x2C    //ro

#define HANG                0x30    //ro
#define ANG15               0x32    //ro
#define ZANG                0x34    //ro

#define IKEY                0x3C    //ro/wo


// A1333 EEPROM command Registers //
#define PWE_E               0x18
#define ABI_E               0x19
#define MSK_E               0x1A
#define PWI_E               0x1B
#define ANG_E               0x1C
#define LPC_E               0x1D
#define COM_E               0x1E
#define CUS_E               0x1F    //costume

// A1333 EEPROM shadow Registers //
#define PWE_S               0x58
#define ABI_S               0x59
#define MSK_S               0x5A
#define PWI_S               0x5B
#define ANG_S               0x5C
#define LPC_S               0x5D
#define COM_S               0x5E


#endif  //LSM9DS0_SH_H

/*  Typical readout (break out)
Welcome to A1333/A1339 configurator
Temperature is now: 28.62
Error is: A0CB
State is: 8090

Read PWE_E
ERDH: D000
ERDL: 0FDF

Read ABI_E
ERDH: 9402
ERDL: 10A4

Read MSK_E
ERDH: A490
ERDL: 1900

Read PWI_E
ERDH: B0C2
ERDL: 710A

Read ANG_E
ERDH: 8802
ERDL: 81D6

Read LPC_E
ERDH: 9480
ERDL: B29F

Read COM_E
ERDH: 500C
ERDL: 094D

IKEY before unlock is: 0000
IKEY is: 0001
Device unlocked

End of A1333/A1339 configurator
*/