#include "mbed.h"
int Command_Flag;
char Receive_Data[10];
double Position_Error,Degree_Error,fSpeedRef_1,fSpeedRef_2;
int  pwm_duty;
double k1,k2,sigma,delta;
void init_PWM(); 
int main()    
{  
    bluetooth.baud(115200);
    pc.baud(57600);
    init_PWM();
    while(1)
    {
        if(bluetooth.readable())
        {
        Receive_Data =bluetooth.getc(); 
        _ISR _U2RXInterrupt();
            if(Command_Flag==1)
            {
            Position_Error=(Receive_Data[2]-0x30)*100+(Receive_Data[3]-0x30)*10+(Receive_Data[4]-0x30); 
            if(Receive_Data[1]=='-')
            Position_Error=-1*Position_Error;
            else Position_Error=Position_Error; 
            Degree_Error=(Receive_Data[6]-0x30)*100+(Receive_Data[7]-0x30)*10+(Receive_Data[8]-0x30);
            if(Receive_Data[5]=='-')
            Degree_Error=-1*Degree_Error;
            else Degree_Error=Degree_Error;
            if(Receive_Data[9]=='j') pwm_duty=148;
            else if (Receive_Data[9]=='k') pwm_duty=100;
            Command_Flag=0;
            } 
        sigma = k1*Position_Error;
        delta = k2*Degree_Error;
        if (sigma > 500){sigma = 500;}
        if (sigma < -500){sigma = -500;}
        if (delta > 500){delta = 500;}
        if (delta < -500){delta = -500;}
        fSpeedRef_1 = sigma + delta;
        fSpeedRef_2 = sigma - delta;
        v1_ref = fSpeedRef_1;
        v2_ref = -1*fSpeedRef_2;
        }
    }
}
void _ISR _U2RXInterrupt(void)
{
static char Temp;
Temp=U2RXREG;
if (Receive_Flag==1)
{
Receive_Counter++;
Receive_Data[Receive_Counter]=Temp;

if(Receive_Counter==9)
{
Command_Flag=1;
Receive_Flag=0;
Receive_Counter=0;
}
}
else
{
if(Temp==36)
{
Receive_Flag=1;
Receive_Counter=0;
Receive_Data[0]= Temp;
}
else
{}
}
IFS1bits.U2RXIF=0;
}

void init_PWM()
{
    mypwm.period_ms(20);
    mypwm.write(servo_duty);
}