#include <string>
using namespace std;
#include "mbed.h"
#ifndef PACEHEART_H
#define PACEHEART_H
class PaceHeart{
    
    private:
        int p_pacingState;
        int p_pacingMode;
        int p_hysteresis;
        int p_hysteresisInterval;
        int lowrateInterval;
        int uprateInterval; //upper rate limit
        //Ventricle
        double p_vPaceAmp;
        double p_vPaceWidth;
        int p_VRP;
        //Atrium (change defaults)
        double p_aPaceAmp;
        double p_aPaceWidth;
        int p_ARP;
    public:
        PaceHeart();
        void pace_A();
        void pace_A(double amp, double wid,int pin);
        void pace_V(double amp, double wid,int pin);
        void pace_V();
        void pace();
        void pace(int x);
        int get_p_pacingState();
        void set_p_pacingState(int x);
        int get_p_pacingMode();
        void set_p_pacingMode(int x);
        int get_p_hysteresis();
        void set_p_hysteresis(int x);
        int get_p_hysteresisInterval();
        void set_p_hysteresisInterval(int x);
        int get_lowrateInterval();
        void set_lowrateInterval(int x);
        int get_uprateInterval();
        void set_uprateInterval(int x);
        double get_p_vPaceAmp();
        void set_p_vPaceAmp(double x);
        double get_p_vPaceWidth();
        void set_p_vPaceWidth(double x);
        int get_p_VRP();
        void set_p_VRP(int x);
        double get_p_aPaceAmp();
        void set_p_aPaceAmp(double x);
        double get_p_aPaceWidth();
        void set_p_aPaceWidth(double x);
        int get_p_ARP();
        void set_p_ARP(int x);
};
#endif