#include "PaceHeart.h"
#include "mbed.h"
#include "Hardware.h"
using namespace std;



PaceHeart::PaceHeart(){
    p_pacingState = 1;
    p_pacingMode = 2;
    p_hysteresis = 0;
    p_hysteresisInterval = 300;
    lowrateInterval = 1000;
    uprateInterval = 500; //upper rate limit
//Ventricle
    p_vPaceAmp = 3500.0;
    p_vPaceWidth = 0.4;
    p_VRP = 320;
//Atrium (change defaults)
    p_aPaceAmp = 3500.0;
    p_aPaceWidth = 0.4;
    p_ARP = 320;
}

int PaceHeart::get_p_pacingState()
{
    return p_pacingState;
}

void PaceHeart::set_p_pacingState(int x)
{
    p_pacingState = x;
    return;
}
int PaceHeart::get_p_pacingMode()
{
    return p_pacingMode;
}
void PaceHeart::set_p_pacingMode(int x)
{
    p_pacingMode = x;
    return;
}
int PaceHeart::get_p_hysteresis()
{
    return p_hysteresis;
}
void PaceHeart::set_p_hysteresis(int x)
{
    p_hysteresis = x;
    return;
}
int PaceHeart::get_p_hysteresisInterval()
{
    return p_hysteresisInterval;
}
void PaceHeart::set_p_hysteresisInterval(int x)
{
    p_hysteresisInterval = x;
    return;
}
int PaceHeart::get_lowrateInterval()
{
    return lowrateInterval;
}
void PaceHeart::set_lowrateInterval(int x)
{
    lowrateInterval = x;
    return;
}
int PaceHeart::get_uprateInterval()
{
    return uprateInterval;
}
void PaceHeart::set_uprateInterval(int x)
{
    uprateInterval = x;
    return;
}
//Ventricle
double PaceHeart::get_p_vPaceAmp()
{
    return p_vPaceAmp;
}
void PaceHeart::set_p_vPaceAmp(double x)
{
    p_vPaceAmp = x;
    return;
}
 
double PaceHeart::get_p_vPaceWidth()
{
    return p_vPaceWidth;
}
void PaceHeart::set_p_vPaceWidth(double x)
{
    p_vPaceWidth = x;
    return;
}
 
int PaceHeart::get_p_VRP()
{
    return p_VRP;
}
void PaceHeart::set_p_VRP(int x)
{
    p_VRP = x;
    return;
}
//Atrium
double PaceHeart::get_p_aPaceAmp()
{
    return p_aPaceAmp;
}
void PaceHeart::set_p_aPaceAmp(double x)
{
    p_aPaceAmp = x;
    return;
}
 
double PaceHeart::get_p_aPaceWidth()
{
    return p_aPaceWidth;
}
void PaceHeart::set_p_aPaceWidth(double x)
{
    p_aPaceWidth = x;
    return;
}
 
int PaceHeart::get_p_ARP()
{
    return p_ARP;
}
void PaceHeart::set_p_ARP(int x)
{
    p_ARP = x;
    return;
}



void PaceHeart::pace_A(double amp, double wid,int pin)
{   
    output_pin_A = !output_pin_A ;
    wait(1);
    //e_gram(amp,wid); //
   /*
   
   
    //default double e_amp[1]; double e_wid[1];int e_size=0; ->get_egram_wid // get_egram_size // get_egram_amp
    void e_gram(double amp, double wid){
    if(size==e_amp.length){
        double e_amp_new[2*size];
        double e_wid_new[2*size];
        for(int i = 0;i<size;i++){
            e_amp_new[i] = amp[i];
            e_wid_new[i] = wid[i];
        }
        e_amp = e_amp_new;
        e_wid = e_wid_new;
    }
    if(size==0){
        e_amp[0] = amp; //storing egram history;
        e_wid[0] = wid;
    }
    else {
        e_amp[size] = amp;
        e_wid[size] = wid;
    }
    }
    double* PaceHeart::get_egram_amp(){
        return e_amp;
    }
    double* PaceHeart::get_egram_wid(){
        return e_wid;
    }
    int PaceHeart::get_egram_size(){
        return e_size;    
    }
    
    
   */
    return;
}

void PaceHeart::pace_A()
{
    double amplitude = get_p_aPaceAmp();
    double width = get_p_aPaceWidth();
    // int output_pin = hardware.get_output_pin; //include the hardware module
    pace_A(amplitude,width,output_pin_A);
    return;
}


void PaceHeart::pace_V(double amp, double wid, int pin)
{
    output_pin_V = !output_pin_V ;
    wait(2);
   
    return;
}

void PaceHeart::pace_V()
{
    double amplitude = get_p_vPaceAmp();
    double width = get_p_vPaceWidth();
    // int output_pin = hardware.get_output_pin; //include the hardware module
    pace_V(amplitude,width,output_pin_V);
    return;
}


void PaceHeart::pace(int mode)
{
    switch(mode){
    case 1:  //AOO
           pace_A();
    case 2:  //VOO
           pace_V();
    }
    return;
}

void PaceHeart::pace()
{
    int mode = get_p_pacingMode();
    pace(mode);
    return;
}/*
void PaceHeart::send_data(Serial &pc){
    
             pc.printf ("%c",(char)get_p_pacingState());
             pc.printf ("%c",(char)get_p_pacingMode());
             pc.printf ("%c",(char)get_p_hysteresis());
             pc.printf ("%c%c",(char)((int)(get_p_hysteresisInterval()/128)),(char)(get_p_hysteresisInterval()%128));
             pc.printf ("%c%c",(char)((int)(get_lowrateInterval()/128)),(char)(get_lowrateInterval()%128));
             pc.printf ("%c%c",(char)((int)(get_p_vPaceAmp())/128),(char)((int)(get_p_vPaceAmp())%128));
             pc.printf ("%c%c",(char)((int)(10.0*get_p_vPaceWidth())/128),(char)((int)(10.0*get_p_vPaceWidth())%128));//10*pace width
             pc.printf ("%c%c\n",(char)((int)(get_p_VRP()/128)),(char)(get_p_VRP()%128));
             return;
}*/
/*    
void PaceHeart::request_data(Serial &pc){ //implement limit later
            char d[14];
            int e = 0;
            pc.scanf("%s",&d);
            pc.printf("%c",'e');//end
            e = (int)d[0];
            set_p_pacingState(e);
            e = (int)d[1];
            set_p_pacingMode(e);
            e = (int)d[2];
            set_p_hysteresis(e);
            e = (int)d[3]*128+(int)d[4];
            set_p_hysteresisInterval(e);
            e = (int)d[5]*128+(int)d[6];
            set_lowrateInterval(e);
            e = (int)d[7]*128+(int)d[8];
            set_p_vPaceAmp((double)e);
            e = (int)d[9]*128+(int)d[10];
            set_p_vPaceWidth((double)e/10.0);
            e = (int)d[11]*128+(int)d[12];
            set_p_VRP(e);
}*/