#include "mbed.h"
#include "FXOS8700Q.h"

//I2C lines for FXOS8700Q accelerometer/magnetometer
FXOS8700Q_acc acc( PTE25, PTE24, FXOS8700CQ_SLAVE_ADDR1);
FXOS8700Q_mag mag( PTE25, PTE24, FXOS8700CQ_SLAVE_ADDR1);
//Temrinal enable
Serial pc(USBTX, USBRX);
MotionSensorDataUnits mag_data;
MotionSensorDataUnits acc_data;


InterruptIn switch1(SW2);

//Setting the motor Pin
DigitalOut motorPin(D10);


void switch1ISR(){
    switch1.fall(NULL);
    //v=1;
    switch1.fall(&switch1ISR);
}

int main()
{
    int cnt =0;
    float faX, faY, faZ;
    float fmX, fmY, fmZ;
    acc.enable();
    printf("\r\n\nFXOS8700Q Who Am I= %X\r\n", acc.whoAmI());


    while (true)
    {
        acc.getAxis(acc_data);
        mag.getAxis(mag_data);
        printf("FXOS8700Q ACC: X=%1.4f Y=%1.4f Z=%1.4f ", acc_data.x, acc_data.y, acc_data.z);
        printf(" MAG: X=%4.1f Y=%4.1f Z=%4.1f\r\n", mag_data.x, mag_data.y, mag_data.z);
        acc.getX(&faX);
        acc.getY(&faY);
        acc.getZ(&faZ);
        mag.getX(&fmX);
        mag.getY(&fmY);
        mag.getZ(&fmZ);
        printf("FXOS8700Q ACC: X=%1.4f Y=%1.4f Z=%1.4f ", faX, faY, faZ);
        printf(" MAG: X=%4.1f Y=%4.1f Z=%4.1f\r\n", fmX, fmY, fmZ);
float NewVal, OldVal;        
        OldVal=faZ;
          
        wait(10);
        printf("Old  ,   New    = %1.4f,    %1.4f  ", OldVal,NewVal);
        NewVal = faZ;
    if (abs((NewVal*1000) - (OldVal*1000))> 10)
    {
        printf("Test it is working.!");
        }

  wait(10);
        motorPin = 1;
        cnt = 1;
        wait(10);
        cnt = 0;
        motorPin = 0;
       wait(10);
   
}
}