#include "mbed.h"
#include "BMP180.h"
#include "HT16K33.h"
 
#define BMP180_ADDRESS 0x77<<1

uint32_t delt_t, count, tempcount;
float temperature, pressure, temppress, altitude;

DigitalOut myled(LED1);
 
BMP180 bmp180; // initialize BMP-180 altimeter

HT16K33 led; // initialize bubble display

Timer t;

Serial pc(USBTX, USBRX); // tx, rx
 
int main() {
 
   t.start();
   
   led.initHT16K33();          // initialize bubble display
   led.clearDsplay(display1);  // clear bubble display1
   led.clearDsplay(display2);  // clear bubble display2
   led.clearDsplay(display3);  // clear bubble display1
   led.clearDsplay(display4);  // clear bubble display2

  // Read the WHO_AM_I register of the BMP-180, this is a good test of communication
    uint8_t c = bmp180.readByte(BMP180_ADDRESS, BMP180_WHO_AM_I);   
    if(c == 0x55) {
 
    pc.printf("BMP-180 is 0x%x\n\r", c);
    pc.printf("BMP-180 should be 0x55\n\r");
    pc.printf("BMP-180 online...\n\r");
   
    bmp180.BMP180Calibration();
    pc.printf("BMP-180 calibration complete...\n\r");
   }
   else 
   {
    pc.printf("BMP-180 is 0x%x\n\r", c);
    pc.printf("BMP-180 should be 0x55\n\r");
    while(1); // idle here forever
   }
   
    /////////////////////////////////////////////////
    // main
    /////////////////////////////////////////////////
 
    while (1) {

    // Average over the display duty cycle to get the best pressure and altitude resolution
    // The sample read time is on the order of 30 ms at the highest resolution using OSS = 3
    // Averaging over the display duty cycle is equivalent to averaging about 500/30 ~ 16 times
    // per display output. If this is too much averaging, one can always reduce the display duty cycle
    
    temperature = (float)bmp180.BMP180GetTemperature()/10.0f;  // Get temperature from BMP-180 in degrees C
    temppress += (float)bmp180.BMP180GetPressure();            // Get pressure from BMP-180 in Pa
    tempcount++;

    // Serial print and/or display at 0.5 s rate independent of data rates
    delt_t = t.read_ms() - count;
    if (delt_t > 500) { // update LCD once per half-second independent of read rate

    myled=!myled;
   
    pressure = temppress/tempcount;  // use average pressure for reading to get ultra-high resolution
    temperature = temperature*9.0f/5.0f + 32.0f;                          // convert to Fahrenheit
    altitude = 44330.0f*( 1.0f - pow((pressure/101325.0f), (1.0f/5.255f))); // Calculate altitude in meters
   
    led.writeFloat(display1, temperature, 1);             // display temperature in degrees Fahrenheit to bubble display
    led.writeFloat(display2, pressure/1000, 2);           // display pressure in mPa to bubble display
    led.writeFloat(display3, altitude, 1);                // display altitude in meters to bubble display
    led.writeFloat(display4, altitude*3.281f, 1);          // display altitude in feet to bubble display

    pc.printf("Temperature is  %.1f C\n\r", temperature); 
    pc.printf("Pressure is  %.3f mPa\n\r", pressure/1000.0f); 
    pc.printf("Altitude is  %.1f m\n\r", altitude);
    pc.printf("Altitude is  %.1f ft\n\r", altitude*3.2810f); 
    pc.printf("\n\r");
  
                
    count = t.read_ms();  
    temppress = 0;
    tempcount = 0;
    }
    }
}
 
