#include "DotStar.h"

SPI SPI1(P0_5,NC,P0_4);

// Constructor for 'soft' (bitbang) SPI -- any two pins can be used
DotStar::DotStar(uint16_t n, uint8_t data, uint8_t clock) :
 dataPin(data), clockPin(clock), brightness(0), pixels(NULL)
{
  updateLength(n);
}

void DotStar::begin(void) { // Initialize SPI
    //SPI1.begin(clockPin, dataPin, P0_29);//SCK, MOSI, MISO
    //SPI1.transfer(0xFF);
}

void DotStar::updateLength(uint16_t n) {
  if(pixels) free(pixels);
  uint16_t bytes = n * 3;              // COLOR: 3 bytes/pixel
  if((pixels = (uint8_t *)malloc(bytes))) {
    numLEDs = n;
    clear();
  } else {
    numLEDs = 0;
  }
}

//-------------------------------------------------------------------------------
//-------------------------------------------------------------------------------
void DotStar::show(void) {

    if(!pixels) return;
    
    
    uint8_t *ptr = pixels, i;            // -> LED data
    uint16_t n   = numLEDs;              // Counter
    uint16_t b16 = (uint16_t)brightness; // Type-convert for fixed-point math
    
    // Soft (bitbang) SPI

    for(i=0; i<4; i++) SPI1.write(0x00);    // Start-frame marker
    if(brightness) {                     // Scale pixel brightness on output
      do {                               // For each pixel...
        SPI1.write(0xFF);                //  Pixel start
        for(i=0; i<3; i++) SPI1.write((*ptr++ * b16) >> 8); // Scale, write
      } while(--n);
    } else {                             // Full brightness (no scaling)
      do {                               // For each pixel...
        SPI1.write(0xFF);                //  Pixel start
        for(i=0; i<3; i++) SPI1.write(*ptr++); // R,G,B
      } while(--n);
    }
    //Remove end-frame below if last led goes all white
    //for(i=0; i<4; i++) SPI1.write(0xFF); // End-frame marker (see note above)
    
}


void DotStar::clear() { // Write 0s (off) to full pixel buffer
  memset(pixels, 0, numLEDs * 3);                   // COLOR: 3 bytes/pixel
}

// Set pixel color, separate R,G,B values (0-255 ea.)
void DotStar::setPixelColor(
 uint16_t n, uint8_t r, uint8_t g, uint8_t b) {
  if(n < numLEDs) {
    uint8_t *p = &pixels[n * 3];
    p[0] = r;
    p[1] = g;
    p[2] = b;
    //SPI1.transfer(0xFF);
  }
}

// Set pixel color, 'packed' RGB value (0x000000 - 0xFFFFFF)
void DotStar::setPixelColor(uint16_t n, uint32_t c) {
  if(n < numLEDs) {
    uint8_t *p = &pixels[n * 3];
    p[0] = (uint8_t)(c >> 16);
    p[1] = (uint8_t)(c >>  8);
    p[2] = (uint8_t)c;
  }
}

// Convert separate R,G,B to packed value
uint32_t DotStar::Color(uint8_t r, uint8_t g, uint8_t b) {
  return ((uint32_t)r << 16) | ((uint32_t)g << 8) | b;
}

// Read color from previously-set pixel, returns packed RGB value.
uint32_t DotStar::getPixelColor(uint16_t n) const {
  if(n >= numLEDs) return 0;
  uint8_t *p = &pixels[n * 3];
  return ((uint32_t)p[0] << 16) |
         ((uint32_t)p[1] <<  8) |
          (uint32_t)p[2];
}

uint16_t DotStar::numPixels(void) { // Ret. strip length
  return numLEDs;
}

// Set global strip brightness.  This does not have an immediate effect;
// must be followed by a call to show().  Not a fan of this...for various
// reasons I think it's better handled in one's sketch, but it's here for
// parity with the NeoPixel library.  Good news is that brightness setting
// in this library is 'non destructive' -- it's applied as color data is
// being issued to the strip, not during setPixel(), and also means that
// getPixelColor() returns the exact value originally stored.
void DotStar::setBrightness(uint8_t b) {
  // Stored brightness value is different than what's passed.  This
  // optimizes the actual scaling math later, allowing a fast 8x8-bit
  // multiply and taking the MSB.  'brightness' is a uint8_t, adding 1
  // here may (intentionally) roll over...so 0 = max brightness (color
  // values are interpreted literally; no scaling), 1 = min brightness
  // (off), 255 = just below max brightness.
  brightness = b + 1;
}

uint8_t DotStar::getBrightness(void) const {
  return brightness - 1; // Reverse above operation
}

// Return pointer to the library's pixel data buffer.  Use carefully,
// much opportunity for mayhem.  It's mostly for code that needs fast
// transfers, e.g. SD card to LEDs.  Color data is in BGR order.
uint8_t *DotStar::getPixels(void) const {
  return pixels;
}