#ifndef _DOT_STAR_H_
#define _DOT_STAR_H_

#include "mbed.h"

class DotStar
{
    public:
        
        DotStar(uint16_t n, uint8_t d, uint8_t c);
        
        void begin();                           // Prime pins/SPI for output
        void clear();                                // Set all pixel data to zero
        void setBrightness(uint8_t);                 // Set global brightness 0-255
        void setPixelColor(uint16_t n, uint32_t c);
        void setPixelColor(uint16_t n, uint8_t r, uint8_t g, uint8_t b);
        void show(void);                             // Issue color data to strip
        void updatePins(void);                       // Change pin assignments (HW)
        void updatePins(uint8_t d, uint8_t c);       // Change pin assignments (SW)
        void updateLength(uint16_t n);               // Change length
        uint32_t
            Color(uint8_t r, uint8_t g, uint8_t b), // R,G,B to 32-bit color
            getPixelColor(uint16_t n) const;        // Return 32-bit pixel color
        uint16_t
            numPixels(void);                        // Return number of pixels
        uint8_t
            getBrightness(void) const,              // Return global brightness
            *getPixels(void) const,                  // Return pixel data pointer
            sine8(uint8_t) const,
            gamma8(uint8_t) const;
        
        
    private:
        uint16_t
            numLEDs;                                // Number of pixels
        uint8_t
            dataPin,                                // If soft SPI, data pin #
            clockPin,                               // If soft SPI, clock pin #
            brightness,                             // Global brightness setting
           *pixels,                                 // LED RGB values (3 bytes ea.)
            rOffset,                                // Index of red in 3-byte pixel
            gOffset,                                // Index of green byte
            bOffset;                                // Index of blue byte
};

#endif