#include "mbed.h"
#include "keypad.h"
#include "TextLCD.h"
#include "beep.h"
//STM32F4-Discovery

TextLCD lcd(PC_1, PC_0, PC_3, PC_2, PA_1, PA_0);// rs e d4-d7
Beep buzzer(PA_15);
// Define your own keypad values
char Keytable[] = { '1', '2', '3', 'A',
                    '4', '5', '6', 'B',
                    '7', '8', '9', 'C',
                    '*', '0', '#', 'D'
                  };

uint32_t cbAfterInput(uint32_t index) {
    //printf("Index:%d => Key:%c\n", key, Keytable[index]);
    buzzer.beep(1500,0.1);
    wait_ms(100);
    buzzer.nobeep(); 
    lcd.cls();
    lcd.printf("Key:%c\n", Keytable[index]);
    return 0;
}

int main() {
    Keypad keypad(PB_3, PD_7, PD_5, PD_6, PB_7, PB_6, PB_5, PB_4);//Row1-2-3-4 Col1-2-3-4 
    keypad.CallAfterInput(&cbAfterInput);
    keypad.Start();

    while (1) {
        wait_ms(100);
    }
}
