#include "mbed.h"
#include "C027.h"
#include "UbloxModem.h"

#define USSD_COMMAND "*100#"
/*
 * Modified USSD example, working with SARA-G350
 * Based on USSDTest and HTTP Test from u-blox
 * Output to PC via USB Serial Port, 9600 Baud
 */

Serial pc(USBTX, USBRX);
C027 c027;

void test(void const*)
{
    c027.mdmPower(true);
    UbloxSerModem modem; // for LISA-C use the UbloxUSBCDMAModem instead
    char result[128];

    pc.printf("Sending %s on USSD channel\n", USSD_COMMAND);

    int ret = modem.sendUSSD(USSD_COMMAND, result, sizeof(result));
    if(ret) {
        pc.printf("Send USSD command returned %d\n", ret);
    }

    pc.printf("Result of command: %s\n", result);

    c027.mdmPower(false);
    
    while(1) {
    }
}


int main()
{
    Thread testTask(test, NULL, osPriorityNormal, 1024 * 4);
    DigitalOut led(LED); // on rev A you should reasign the signal to A0
    while(1) {
        led=!led;
        Thread::wait(1000);
    }

    return 0;
}
