#include "mbed.h"
#include "C027.h"
#include "UbloxModem.h"

#include "NTPClient.h"

/*
 * Modified NTP example, working with SARA-G350
 * Based on NTPClentTest and HTTP Test from u-blox
 * Output to PC via USB Serial Port, 9600 Baud
 * Output of mbed IDE tells that this example uses more RAM than available, but it's working somehow...
 */

C027 c027;
Serial pc(USBTX, USBRX);

void test(void const*)
{
    c027.mdmPower(true);
    UbloxSerModem  modem; // for LISA-C use the UbloxUSBCDMAModem instead
    NTPClient ntp;

    int ret = modem.connect("internet"); // eventaully set another apn here
    if(ret) {
        pc.printf("Could not connect\n");
        return;
    }

    pc.printf("Trying to update time...\r\n");
    if (ntp.setTime("0.pool.ntp.org") == 0) {
        pc.printf("Set time successfully\r\n");
        time_t ctTime;
        ctTime = time(NULL);
        pc.printf("Time is set to (UTC): %s\r\n", ctime(&ctTime));
    } else {
        pc.printf("Error\r\n");
    }

    modem.disconnect();
    c027.mdmPower(false);
    
    while(1) {
    }
}


int main()
{
    Thread testTask(test, NULL, osPriorityNormal, 1024 * 4);
    DigitalOut led(LED); // on rev A you should reasign the signal to A0
    while(1) {
        led=!led;
        Thread::wait(1000);
    }

    return 0;
}
