#include "mbed.h"
#include "pb.h"
#include "pb_decode.h"
#include "pb_encode.h"
#include "LEX_Initialisation.pb.h"
#include "MODSERIAL.h"

DigitalOut led1(LED1);
MODSERIAL pc(USBTX, USBRX, 512);
uint8_t buffer_i[512];
uint8_t buffer_o[512];
size_t message_length_o;
size_t message_length_i;
bool status;
int i = 0;
char c = 0;
char cn = 0;
char cnn = 0;
volatile bool sent_flag = false;
Configuration config_o;
Configuration config_i;


//indicator LEDs
DigitalOut signal1(p26);       //Green
DigitalOut signal2(p25);         //Red

//Parameters
float r_set_array[5] = {0.5,0.53,0.55,0.56,0.5};
int time_array[5] = {500,1000,1500,2500,3000};
int trig_array[5] = {50,250,0,100,100};
    
void read_message(){
    if (pc.scanf("%d",&message_length_i) < 0){pc.printf("Error in reading message length");}
    for (int i = 0; i < message_length_i; i++) {
        i = i % sizeof(buffer_i);
        c = pc.getc();
        if (c != '#'){
            buffer_i[i] = c;
            }  
        pc.putc(buffer_i[i]);
        }
    }      

void write_message(){
    pc.printf("%d ",message_length_o);
    for (int i = 0; i < message_length_o; i++) {
        if (buffer_o[i] == NULL){
            pc.putc('#');
            }
        else{
            pc.putc(buffer_o[i]);
            }
    }
}
       
       
template <typename T>
void decode_message(T * message_ptr, char type){
            // Create a stream that reads from the buffer. 
                
                pb_istream_t istream = pb_istream_from_buffer(buffer_i, message_length_i);
        
                //Now we are ready to decode the message. 
                if (type == 'c'){
                    status = pb_decode(&istream, Configuration_fields, message_ptr);
                }
                else{
                    status = pb_decode(&istream, SetPoint_fields, message_ptr);
                }
        
                // Check for errors... 
                if (!status)
                {
                    pc.printf("Decoding failed: %s\n", PB_GET_ERROR(&istream));
                }
            }
    
template <typename T>
void encode_message(T * message_ptr, char type){
    pb_ostream_t ostream = pb_ostream_from_buffer(buffer_o, sizeof(buffer_o));
    if (type == 'c'){
        status = pb_encode(&ostream, Configuration_fields, message_ptr);
    }
    else{
        status = pb_encode(&ostream, SetPoint_fields, message_ptr);
    }
    message_length_o = ostream.bytes_written;
    
    if (!status)
    {
        pc.printf("Encoding failed: %s\n", PB_GET_ERROR(&ostream));
    }
}

// main() runs in its own thread in the OS
int main()
{
    /* This is the buffer where we will store our message. */
    pc.baud(115200);
    int n_points = sizeof(r_set_array)/sizeof(float);

    SetPoint set_point_o[n_points];
    
    //Set set points  

    config_o.n_set_points = n_points;
    encode_message<Configuration>(&config_o,'c');
    write_message();
    
    for (int point = 0; point < n_points ; point++){
        set_point_o[point].r_set_point = r_set_array[point];
        set_point_o[point].time_point = time_array[point];
        set_point_o[point].trig_time = trig_array[point];
        encode_message<SetPoint>(&set_point_o[point],'s');
        write_message();
        }
       

    
    
    pc.getc();
    pc.printf("\n Input your set point:\n");
    read_message();

    decode_message<Configuration>(&config_i,'c');
    printf("Config decoded - there are %d points \n",config_i.n_set_points);
    
    SetPoint set_point_i[config_i.n_set_points];
    for (int point = 0; point < config_i.n_set_points; point++){
        read_message();
        for (i = 0; i < message_length_i; i++){
            pc.putc(buffer_i[i]);
            pc.putc(buffer_o[i]);
            if (buffer_i[i] == buffer_o[i]){pc.putc('y');}
            else {pc.putc('n');}
            pc.printf("\n");
            wait_us(50);
        }
        decode_message<SetPoint>(&set_point_i[i],'c');
        printf("Set point %d is %f,at %d, with a trigger at %d",i,set_point_i[i].r_set_point,set_point_i[i].time_point,set_point_i[i].trig_time);
    }
    
    
    
    while(1);
    return 0;
}


