#include "mbed.h"
#include "MODSERIAL.h"
#include "ADS8568_ADC.h"
#include "Heater.h"
#include "FastPWM.h"

#define ALL_CH              15     //value of convst bus to read all chanels simultaneosly

float r_gradient;
float r_set_points[5] = {0.0,0.50,0.51,0.52,0.50};
int time_points[5] = {0,5000,10000,15000,20000};
int trig_time[5] = {0,0,50,50,50};
int curr_time;
//Globals
int camera_read_time;

MODSERIAL pc(PA_9, PA_10, 512); //mcu TX, RX, 512 byte TX and RX buffers
ADS8568_ADC adc(PB_15, PB_14, PB_13, PB_12, PC_15, PC_0, PC_1, PC_2, PC_3);
I2C i2c(PB_7, PB_8);            //SDA, SCL
Timer timer;
DigitalIn adc_busy(PA_8);                   //Busy interrupt sig#


//Heater Control
FastPWM drive_1(PC_9);
FastPWM drive_2(PC_8);
FastPWM guard_1(PC_7);
FastPWM guard_2(PC_6);


//Heaters
Heater heater_1(0,1,&drive_1, &guard_1, 525.2, -206);
Heater heater_2(2,3,&drive_2, &guard_2, 525.2, -206);

//indicator LEDs
DigitalOut hb_led(PC_13);       //Green
DigitalOut led_0(PC_4);         //Red
DigitalOut led_1(PC_5);         //Green

//User buttons
DigitalIn user_0(PB_0);
DigitalIn user_1(PB_1);

BusOut converts(PC_0, PC_1, PC_2, PC_3);


//Threads
Thread serial_listen;
Thread heater_control;

//Semaphores
Semaphore heater_semaphore;

//Tickers
Ticker heat_tick;
Ticker pressure_tick;


//Flags
bool start_flag = false;
bool config_flag = false;
volatile bool heater_flag = false;
bool triggered_flag = false;
bool untriggered_flag = false;


//Functions

void serial_rx(){
    while(pc.getc() != 'c');
    config_flag = true;
    while(pc.getc() != 's');
    start_flag = true;
    }
    
    
void temp_trigger() {
    heater_flag = true;
    led_1 = !led_1;
    }

void temp_control() {
    while(1){
        while(!heater_flag);
        heater_1.update();
        } 
    }

    
void set_point_routine() {
    for (int i_set = 1; i_set < sizeof(r_set_points)/sizeof(float); i_set ++){
        r_gradient = (r_set_points[i_set] - r_set_points[i_set-1])/(time_points[i_set] - time_points[i_set-1]);
        while ((curr_time = timer.read_ms()) <= time_points[i_set]){
            heater_1.Set_ref(r_set_points[i_set-1] + r_gradient * (curr_time - time_points[i_set-1]));
            if (!triggered_flag && curr_time > time_points[i_set - 1] + trig_time[i_set]){
                //Start camera trigger
                triggered_flag = true;
                }
            if (!untriggered_flag && curr_time > time_points[i_set - 1] + trig_time[i_set] + camera_read_time){
                //End camera read
                untriggered_flag = true;
                }
            wait_ms(1);
        }
        
    }
}   

void pressure_control() {
    //Input pressure control function here
    //i.e.
    //read_pressure();
    //if (pressure < lower_bound) {
            //pump_turn_on();
        //}
    //else if (pressure > upper_bound) {
            //pump_turn_off();
        //}
    }
            

        
        
int main() {
    pc.baud(115200);
    
    serial_listen.start(&serial_rx);
    heater_control.start(& temp_control);
    pressure_tick.attach(& pressure_control, 1);
    heat_tick.attach_us(& temp_trigger,3000);
    
    while (!start_flag){
        pc.printf("Waiting for start signal\n");
        wait(1);
        }
    
    pc.printf("Starting routine...\n");
    set_point_routine();


    }