/*------------------------------------------------------------------------------
Library header file for heater operations
Date: 16/07/2018


------------------------------------------------------------------------------*/

#ifndef Heater_H
#define Heater_H
#include "mbed.h"
#include "ADS8568_ADC.h"
#include "FastPWM.h"
#include "memspcr.pb.h"


#define ALL_CH              15     //value of convst bus to read all chanels simultaneosly
#define WIND_UP_LIMIT       0.1f //The change in error which turns off the integral term


class Heater
{
    //This class provides the interface through which each heater can be controlled
    public:
        /** Constructor
                 * @param thermal passes in all the information needed for the heater
        **/         
        Heater(const memspcr_ThermalConfiguration & );
        
        //Public member functions

        void read();            //Updates the resistance and error values for the heater
        void update();  //Holds R_ref for hold_time miliseconds
        void ramp_R(const int ramp_time, const float R_final, const float R_start);   //Ramps for ramp_time miliseconds from R_start to R_final
        void log() const;  //Prints the current state of the heater
        void turn_on();     //Turns the heater on
        void turn_off();    //Turns the heater off
        
                


        
        
        //Getters and setters
        void Set_ref(float R);
        void Set_D(float D);
        int Get_i() const;
        int Get_v() const;
        float Get_R() const;
        
        


        
    
    protected:
        
        const memspcr_ThermalConfiguration thermal;
        int curr;       //Latest current reading from ADC
        int v;          //Latest voltage reading from ADC
        float R;        //Latest resistance calculated from ADC current and voltage
        float R_ref;    //Current referance for resistance
        float error;    //R_ref - R
        float error_integrated; //Integrated error
        
        int i_port;     //ADC port which corresponds to current measurements
        int v_port;     //ADC port which corresponds to voltage measurements
        FastPWM * drive;    //Pointer to the driver
        FastPWM * guard;    //Pointer to the guard

        //Heater correlations give temperature for a given resistance (assume linear relationship)
        int log_count;
      
};
    
#endif