/*------------------------------------------------------------------------------
Library header file for ADS8568 TI 16 bit 8 channel sampling ADC
Date: 15/07/2018
Author: AS7


------------------------------------------------------------------------------*/

#ifndef ADS8568_ADC_H
#define ADS8568_ADC_H
#include "mbed.h"

#ifndef ADC_CONV_ALL_CH
#define ADC_CONV_ALL_CH    15
#endif

class ADS8568_ADC
{
    public:
        /** Constructor
                 * @param MOSI SPI pin
                 * @param MISO SPI pin
                 * @param SCLK SPI pin
                 * @param nCS SPI pin
                 * @param ADC reset pin
                 * @param Conv chA pin
                 * @param Conv chB pin
                 * @param Conv chC pin
                 * @param Conv chD pin
                 */
        ADS8568_ADC(PinName mosi, PinName miso, PinName sclk, PinName ncs, PinName reset, PinName convA, PinName convB, PinName convC, PinName convD);
        //ADS8568_ADC(SPI bus, DigitalOut adc_nselect, DigitalOut adc_reset
        
        void init();
        
        void start_conversion(int channel);
        int read_channels();
        int read_channel_result(int channel);
        int new_data_channels();
        int OSR;
        
    
    protected:
        SPI bus;
        DigitalOut adc_nselect;
        DigitalOut adc_reset;
        BusOut converts;
        
        char buffer[16];
        int values[8];
        int val_array[8];
        char dummy;
        int channels_read;
        
    };
    
#endif
    