/*------------------------------------------------------------------------------
Library code file for interface to ADS8568 TI 16 bit 8 channel sampling ADC
Date: 15/07/2018
Author: AS7


------------------------------------------------------------------------------*/

#include "ADS8568_ADC.h"
extern DigitalOut led_0;

    
ADS8568_ADC::ADS8568_ADC(PinName mosi, PinName miso, PinName sclk, PinName ncs,PinName reset, PinName convA, PinName convB, PinName convC, PinName convD)
: bus(mosi, miso, sclk), adc_nselect(ncs), adc_reset(reset), converts(convA, convB, convC, convD)
{
    /*
    bus = new SPI(mosi, miso, sclk);
    adc_nselect = new DigitalOut(ncs);
    adc_reset = new DigitalOut(reset);
    converts = new BusOut(convA, convB, convC, convD);
    */
    
    //constants are defined in protected and initialised here

    channels_read = 0;
    OSR = 1;
    dummy = 0;
    
}

void ADS8568_ADC::init()
{
    //set SPI serial to 2MHz, 16 bit data transfer, mode 2 (clock normally high, data preceeding clock cycle) 
    bus.format(8,2);
    bus.frequency(2000000);
    bus.set_default_write_value(0x00);
    adc_nselect = 1;
    
    //Reset ADC sequence
    adc_reset = 1;
    wait_ms(1);
    adc_reset = 0;    
}

void ADS8568_ADC::start_conversion(int channels)
{
    //send convert signal to all channels

    converts = channels;
    wait_us(1);
    converts = 0;
    
    //save which channels have been converted
    channels_read = channels;
}

int ADS8568_ADC::read_channels()
{

    //SPI(like) data transfer
    adc_nselect = 0;
    bus.write(&dummy, 1, buffer, 16);
    adc_nselect=1;
    
    //loop over bytes to add channel voltage values
    for (int x=0; x<8; x++){
            val_array[x] = buffer[2*x]<<8 | buffer[(2*x) + 1];
            values [x] = val_array[x]; 
        }
    
            
    return 0;
}

int ADS8568_ADC::read_channel_result(int channel)
{
    //make sure channel exists to prevent memory error
    if(channel >= 0 && channel < 8)
    {
        //update channels_read to indicate which data has been converted but not read into application
        channels_read = channels_read - (channels_read & channel);
        
        //return ADC channel value        
        return values[channel];
        }
        
    //if error return -1 
    return -1;
}

int ADS8568_ADC::new_data_channels()
{
    //check which channels have been converted but not read yet
    return(channels_read);
}