#include "mbed.h" 
#include "MFRC522.h" 
#include "ESP8266.h"
// FRDM-K64F (Freescale) Pin for MFRC522 reset 
#define MF_RESET    PTD0 
#define SERIAL_1

DigitalOut LedGreen(LED2); 
ESP8266 wifi(PTE0, PTE1, 115200); // Setting up Baud Rate for WIFI ESP Module
char snd[255],rcv[1000];

#define IP "184.106.153.149" // Defining Thingspeak IP Address

//Serial connection to PC for output 
Serial pc(PTC17, PTC16); // serial comm on the FRDM board

//wireless bluetooth connection to Android Device for output
Serial blue(PTC15, PTC14);   
//Defining the necessary Functions to be used//

void wifi_send(void);

int cnt;

 
//MFRC522    RfChip   (SPI_MOSI, SPI_MISO, SPI_SCK, SPI_CS, MF_RESET); 
MFRC522    RfChip   (PTD2, PTD3, PTD1, PTE25, PTD0); 
 
int main(void) { 
   
   blue.baud(9600);
   pc.baud(9600);
   printf("Welcome to RFID Tag Reader Using FRDM K64F...\n\r");
   blue.printf("Welcome to RFID Tag Reader Uing FRDM K64F...\n\r");
   printf("Bluetooth Enable\r\n");
   blue.printf("Bluetooth Enable\r\n");
   RfChip.PCD_Init(); 
 
   while (true) { 
     LedGreen = 1; 
 
     // Look for new cards 
     if ( ! RfChip.PICC_IsNewCardPresent()) 
     { 
       wait_ms(200);
       pc.printf("Now uploading status to Cloud, A bottle was detected\n\r");
            wifi_send(); 
       continue; 
     } 
 
     // Select one of the cards 
     if ( ! RfChip.PICC_ReadCardSerial()) 
     { 
       wait_ms(200); 
       continue; 
     } 
      LedGreen = 0;
      int a=0; 
 
     // Print Card UID 
     printf("Card UID:"); 
     blue.printf("Card UID:");
     for (uint8_t i = 0; i < RfChip.uid.size; i++) 
     { 
      printf(" %X02 ", RfChip.uid.uidByte[i]);
      blue.printf(" %X02 ", RfChip.uid.uidByte[i]);
      a = RfChip.uid.uidByte[0];
     }  
     
     //Print Card Type
    if(a==117 || a==177)  
    { 
         printf("\r\nWhite Card");
         blue.printf("\r\nWhite Card");
     }
     else if(a==226 || a==20)
     {
         printf("\r\nBlue Keychain");
         blue.printf("\r\nBlue Keychain");
     }
     else
     {
         printf("\r\nUnrecognized");
         blue.printf("\r\nUnrecognized");
     }     
     printf("\n\r"); 
     blue.printf("\n\r"); 
     
     // Print RFID Card type 
     uint8_t piccType = RfChip.PICC_GetType(RfChip.uid.sak); 
     printf("PICC Type: %s \n\n\r\r", RfChip.PICC_GetTypeName(piccType));
     blue.printf("PICC Type: %s \n\n\r\r", RfChip.PICC_GetTypeName(piccType));
     
     wait_ms(200); 
     
   } 
 } 
 
     
// WIFI Initialization Part//
    
    pc.printf("SET mode to AP\r\n");
    wifi.SetMode(1);    // Setting ESP to mode 1
    wifi.RcvReply(rcv, 1000);    //In order to receive response from ESP
    pc.printf("%s",rcv);    //Display obtained response on TeraTerm
    pc.printf("Conneting to AP\r\n");
    
    //wifi.Join("BHTG1672G3FC2-2G", "5f17baeb");    
    wifi.Join("Specturm-9", "Redhat1144"); // Add Username and Password of the Network to which WIFI ESP module is connected
    wifi.RcvReply(rcv, 1000);    //In order to receive response from ESP
    pc.printf("%s", rcv);    //Display obtained response on TeraTerm
    wait(8);  //Wait for 8 seconds
    
    pc.printf("Getting IP\r\n");    // Gets IP address
    wifi.GetIP(rcv);    //To receive IP
    pc.printf("%s", rcv);//Display obtained response on TeraTerm    
    wait(5); // Delay 5 sec to give the pir time to get snapshut of the surrounding
    pc.printf("Initializing WiFi\r\n");
 
void wifi_send(void)
{   
pc.printf("*************Uploading WIFI Data*************\r\n");

    pc.printf("\r\nTo set WIFI into Single Channel mode\r\n");

    strcpy(snd,"AT+CIPMUX=0");//To Set WIFI into Single Channel mode
    wifi.SendCMD(snd);
    pc.printf(snd);
    
    wifi.RcvReply(rcv, 1000);
    pc.printf("\r\nMode Status: %s", rcv);
    


//Connecting to THINGSPEAK server// 
    pc.printf("\r\nConnecting to THINGSPEAK server\r\n");
    strcpy(snd,"AT+CIPSTART=\"TCP\",\"api.thingspeak.com\",80");    
    pc.printf("\r\nSending: %s",snd);
    wifi.SendCMD(snd);
    wifi.RcvReply(rcv, 1000);
    pc.printf("\r\nSever Status: %s", rcv);
    
//Deliver Data/Characters//   
    pc.printf("\r\nDelivering Data..");
    strcpy(snd,"AT+CIPSEND=84");  
    wifi.SendCMD(snd);
    pc.printf("\r\nSending: %s",snd); 
    wifi.RcvReply(rcv, 1000);
    pc.printf("\r\nSent Status: %s", rcv);
    
//Upload values to Cloud based website i.e. ThingSpeak in order to obtain Graphical Display//

    pc.printf("Uploading values to Thingspeak\r\n");
    sprintf(snd,"GET https://api.thingspeak.com/update?api_key=WZXOHNJSLN9G1AGP&field1=%d HTTP/1.0\r\n\r\n",cnt);   //67,76,84
    //sprintf(snd,"GET https://api.thingspeak.com/update?key=2DNGOOKD3OZBMVV5&field1=%d HTTP/1.0\r\n\r\n",cnt);   //67,76,84
    pc.printf("\r\nSending: %s",snd);
    wifi.SendCMD(snd);
    wait(1);
    wifi.RcvReply(rcv, 1000);
    pc.printf("\r\nSent Status: %s", rcv);
    wait(1);

//Closing the connection with Server//
   
    pc.printf("\r\nClose the Connection\r\n");                                
    strcpy(snd,"AT+CIPCLOSE");        //Command used to close the connection with server
    wifi.SendCMD(snd);
    pc.printf("\r\nSending: %s",snd);
    wait(1);
    wifi.RcvReply(rcv, 1000);
    pc.printf("Close Connection Status: %s", rcv);   

    pc.printf("\r\nClose connection\r\n");                                
    strcpy(snd,"AT+CIPCLOSE");        
    wifi.SendCMD(snd);
    pc.printf("\r\nSending: %s",snd);
    wifi.RcvReply(rcv, 1000);
    pc.printf("Close Connection Status: %s", rcv);
    pc.printf("\r\nEnd of Closed Connection Status Response\r\n\r\n");
    
}