#include "nnio_stm32f10x_rtc.h"

// Enable this to use external clock, or disable to use internal clock
#define ENABLE_LSE_CLOCK

void RTC_Init(void)
{
    NVIC_InitTypeDef NVIC_InitStructure;

    NVIC_InitStructure.NVIC_IRQChannel = RTC_IRQn;
    NVIC_InitStructure.NVIC_IRQChannelPreemptionPriority = 1;
    NVIC_InitStructure.NVIC_IRQChannelSubPriority = 0;
    NVIC_InitStructure.NVIC_IRQChannelCmd = ENABLE;
    NVIC_Init(&NVIC_InitStructure);
}

/*******************************************************************************
* Function Name  : RTC_Configuration
* Description    : Configures the RTC.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void RTC_Configuration(void)
{
    /* Enable PWR and BKP clocks */
    RCC_APB1PeriphClockCmd(RCC_APB1Periph_PWR | RCC_APB1Periph_BKP, ENABLE);
        
    /* Allow access to BKP Domain */
    PWR_BackupAccessCmd(ENABLE);
    
    /* Reset Backup Domain, only the first time */
    if (BKP_ReadBackupRegister(BKP_DR1) != 0xA5A5)
        BKP_DeInit();

#if defined(ENABLE_LSE_CLOCK)
    /* Enable LSE */
    RCC_LSEConfig(RCC_LSE_ON);

    /* Wait till LSE is ready */
    while (RCC_GetFlagStatus(RCC_FLAG_LSERDY) == RESET)
    {}
        
    /* Select LSE as RTC Clock Source */
    RCC_RTCCLKConfig(RCC_RTCCLKSource_LSE);
#else
    /* Enable LSI */
    RCC_LSICmd(ENABLE);

    /* Wait till LSI is ready */
    while (RCC_GetFlagStatus(RCC_FLAG_LSIRDY) == RESET)
    {}

    /* Select LSI as RTC Clock Source */
    RCC_RTCCLKConfig(RCC_RTCCLKSource_LSI);
#endif
       
    /* Enable RTC Clock */
    RCC_RTCCLKCmd(ENABLE);
        
    /* Wait for RTC registers synchronization */
    RTC_WaitForSynchro();
        
    /* Wait until last write operation on RTC registers has finished */
    RTC_WaitForLastTask();
        
    /* Enable the RTC Second */
    RTC_ITConfig(RTC_IT_SEC, ENABLE);
        
    /* Wait until last write operation on RTC registers has finished */
    RTC_WaitForLastTask();
        
    /* Set RTC prescaler: set RTC period to 1sec */
    RTC_SetPrescaler(32767); /* RTC period = RTCCLK/RTC_PR = (32.768 KHz)/(32767+1) */
        
    /* Wait until last write operation on RTC registers has finished */
    RTC_WaitForLastTask();
}