#ifndef __DEVICE_CONFIGURATION_H
#define __DEVICE_CONFIGURATION_H

#include "mbed.h"
#include "eeprom_flash.h"


// Default device network configuration
#define DEFAULT_IP_ADDRESS      "192.168.0.120"
#define DEFAULT_IP_SUBNET       "255.255.255.0"
#define DEFAULT_IP_GATEWAY      "192.168.0.1"
#define DEFAULT_REMOTE_TCP_SERVER_IP        "192.168.0.2"
#define DEFAULT_REMOTE_UDP_SERVER_IP        "192.168.0.2"
#define DEFAULT_MAC0            0x00
#define DEFAULT_MAC1            0x08
#define DEFAULT_MAC2            0xDC
#define DEFAULT_MAC3            0x00
#define DEFAULT_MAC4            0x00
#define DEFAULT_MAC5            0x01
#define DEFAULT_LOCAL_TCP_SERVER_PORT   10000 // change to 7000 if internet required
#define DEFAULT_LOCAL_UDP_SERVER_PORT   11000
#define DEFAULT_TRANSMIT_PERIOD         1000
#define DEFAULT_REMOTE_TCP_SERVER_PORT  10000
#define DEFAULT_REMOTE_UDP_SERVER_PORT  11000

#define DEFAULT_ENABLE_FLAG_VALUE   0xA5A5
#define DEFAULT_DISABLE_FLAG_VALUE  0xAAAA

#define DEFAULT_INTER_DATA_PERIOD   500 // in ms
#define DEFAULT_SPECIAL_CHARACTER   '\n' // LF

#define DEFAULT_UART_BAUDRATE       9 // 0: 1200, 2400, 4800, 9600, 14400, 19200, 28800, 38400, 57600, 115200 (default), 10: 230400
#define DEFAULT_UART_BITS           8 // 5 to 8 (default)
#define DEFAULT_UART_STOPBITS       1 // 1 (default) or 2
#define DEFAULT_UART_PARITY         0 // 0: None (default), 1: Even, 2: Odd
#define DEFAULT_UART_HANDSHAKE      0 // 0: None (default), 1: RTS/CTS

// Positions of variables in EEPROM array
#define IP_ADDRESS_POS         0 // 4x16-bit
#define IP_SUBNET_POS          8 // 4x16-bit
#define IP_GATEWAY_POS         16 // 4x16-bit
#define MAC_ADDRESS_POS             24 // 3x16-bit
#define DEVICE_CONFIGURED_FLAG_POS  30 // 16-bit
#define LOCAL_TCP_SERVER_PORT_POS   32 // 16-bit
#define LOCAL_UDP_SERVER_PORT_POS   34 // 16-bit
// if TCP client is enabled, use parameters below to set parameters for the remote TCP server
#define REMOTE_TCP_SERVER_IP_ADDR_POS   36 // 4x16-bit
#define REMOTE_TCP_SERVER_PORT_POS      44 // 16-bit
#define AUTO_TRANSMIT_FLAG_POS          46 // 16-bit
#define AUTO_TRANSMIT_TIME_PERIOD_POS   48 // 16-bit
// If UDP client is enabled, use parameters below
#define REMOTE_UDP_SERVER_IP_ADDR_POS   50 // 4x16-bit
#define REMOTE_UDP_SERVER_PORT_POS      58 // 16-bit
// enable modes
#define ENABLE_TCP_SERVER_POS   60 // 16-bit
#define ENABLE_TCP_CLIENT_POS   62 // 16-bit
#define ENABLE_UDP_SERVER_POS   64 // 16-bit
#define ENABLE_UDP_CLIENT_POS   66 // 16-bit
// serial inter-data period
#define INTER_DATA_PERIOD_POS   68 // 16-bit
// special character signals sending data
#define SPECIAL_CHAR_POS        70 // 16-bit
// Uart
#define UART_BAUDRATE_POS       72 // 16-bit
#define UART_BITS_POS           74 // 16-bit
#define UART_STOPBITS_POS       76 // 16-bit
#define UART_PARITY_POS         78 // 16-bit
#define UART_HANDSHAKE_POS      80 // 16-bit
// DHCP vs Static
#define ENABLE_DHCP_POS         82 // 16-bit


// prototypes
void erase_device_configuration();
void write_device_configuration(uint16_t* ip, uint16_t* subnet, uint16_t* gateway, uint16_t* mac,
            uint16_t tcp_port, uint16_t udp_port,
            uint16_t* remote_tcp_ip, uint16_t remote_tcp_port, uint16_t auto_transmit, uint16_t transmit_period,
            uint16_t* remote_udp_ip, uint16_t remote_udp_port,
            uint16_t enable_tcp_server, uint16_t enable_tcp_client, uint16_t enable_udp_server, uint16_t enable_udp_client,
            uint16_t inter_data_period, uint16_t special_char,
            uint16_t uart_baudrate, uint16_t uart_bits, uint16_t uart_stopbits, uint16_t uart_parity, uint16_t uart_handshake,
            uint16_t enable_dhcp);
void read_device_configuration();
void reset_default_device_configuration();

#endif
