#ifndef HTTP_SERVER
#define HTTP_SERVER

#include <map>

#include "mbed.h"
#include "mbed_rpc.h"
#include "RequestHandler.h"
#include "Formatter.h"
#include "EthernetInterface.h"
#include "RPCCommand.h"


class HTTPServer
{
    public :
    
        HTTPServer(Formatter *f = new Formatter());
        virtual ~HTTPServer();
        
        bool init(int port);

        void run();
        
        void add_request_handler(char *name, RequestHandler* handler);
        
    private :

        void handle_request(char *buffer);
        
        TCPSocketServer socket;
        std::map<char*, RequestHandler*, bool(*)(char*, char*)> handlers;
        Formatter *formatter;
        char reply[RPC_MAX_STRING];
        RPCCommand command;
};

#endif

