#include "mbed.h"
#include "mbed_rpc.h"
#include "RPCType.h"


RPCType::RPCType():
supported_types()
{
}

RPCType& RPCType::instance()
{
    static RPCType t;
    return t;
}

void RPCType::register_types()
{
    RPCType &t = instance();
    
    RPC::add_rpc_class<RpcDigitalOut>();
    t.supported_types.push_back("DigitalOut");
    RPC::add_rpc_class<RpcDigitalIn>();
    t.supported_types.push_back("DigitalIn");
    RPC::add_rpc_class<RpcDigitalInOut>();
    t.supported_types.push_back("DigitalInOut");

    #if DEVICE_ANALOGIN
    RPC::add_rpc_class<RpcAnalogIn>();
    t.supported_types.push_back("AnalogIn");
    #endif
    #if DEVICE_PWMOUT
    RPC::add_rpc_class<RpcPwmOut>();
    t.supported_types.push_back("PwmOut");
    #endif
    #if DEVICE_SPI
    t.supported_types.push_back("SPI");
    RPC::add_rpc_class<RpcSPI>();
    #endif
    #if DEVICE_SERIAL
    t.supported_types.push_back("Serial");
    RPC::add_rpc_class<RpcSerial>();
    #endif
    RPC::add_rpc_class<RpcTimer>();
    t.supported_types.push_back("Timer");
}

bool RPCType::is_supported_type(char *type)
{
    for(std::list<char*>::iterator itor = instance().supported_types.begin();
        itor != instance().supported_types.end();
        ++itor)
        if(!strcmp(*itor,type))
            return true;

    return false;
}


