#include "Formatter.h"
#include "mbed.h"
#include "RPCObjectManager.h"
#include "EthernetInterface.h"

/*
const char *SIMPLE_HTML_CODE = "\
<!DOCTYPE html>\
<html>\
<head>\
<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">\
<title>TCP Server</title>\
</head>\
 <body>";


const char* INTERACTIVE_HTML_CODE_1 = "\
<!DOCTYPE html> \
<html>\
<head>\
<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">\
<title>TCP Server</title>\
<script type=\"text/javascript\">\
var ip = \"%s\";\
function submitCreateForm()\
{\
var list = document.getElementById(\"type\");\
var type = list.options[list.selectedIndex].value;\
var name = document.getElementById(\"name\").value;\
if(name === \"\") \
return;\
var arg = document.getElementById(\"arg\").value;\
var url;\
if(arg === \"\") url = \"http://\" + ip + type + \"new?name=\" + name;\
else url = \"http://\" + ip + type + \"new?arg=\" + arg + \"&name=\" + name;\
location.href= url;\
}\
function submitCallFuncForm()\
{\
var command = document.getElementById(\"command\").value;\
if(command === \"\") \
return; \
var tmp = command.split(\' \');\
var url = tmp[0];\
if(tmp.length > 1)\
url += \"?\";\
for(var i = 1; i < tmp.length; ++i)\
{\
url += \"arg\" + i + \"=\" + tmp[i];\
if(i+1 < tmp.length)\
url += \"&\";\
}\
location.href = url;\
}\
</script>\
</head> \
<body>";
    
const char* INTERACTIVE_HTML_CODE_2 = "<h3>Create Object :</h3>\
<form>\
Type: <select id=\"type\">\
<option value=\"/DigitalOut/\">DigitalOut</option>\
<option value=\"/DigitalIn/\">DigitalIn</option>\
<option value=\"/DigitalInOut/\">DigitalInOut</option>\
<option value=\"/AnalogIn/\">AnalogIn</option>\
<option value=\"/PwmOut/\">PwmOut</option>\
<option value=\"/Timer/\">Timer</option>\
</select><br>\
name: <input type=\"text\" id=\"name\"><br>\
arg(optional): <input type=\"text\" id=\"arg\">\
<p><input type=\"button\" value=\"Create\" onclick=\"javascript:submitCreateForm();\"></p>\
</form> \
 \
<h3>Call a function :</h3>\
<p>Enter an RPC command.</p>\
<form>\
Command: <input type= \"text\" id=\"command\" maxlength=127><br>\
<p><input type=\"button\" value=\"Send\" onclick=\"javascript:submitCallFuncForm();\"></p><br>\
</form>\
</body> \
</html>";
*/


const char *SIMPLE_HTML_CODE = "\
<!DOCTYPE html>\
<html>\
<head>\
<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">\
<title>NNIO Server</title>\
</head>\
 <body>";


const char* INTERACTIVE_HTML_CODE_1 = "\
<!DOCTYPE html> \
<html>\
<head>\
<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">\
<title>TCP Server</title>\
<script type=\"text/javascript\">\
var ip = \"%s\";\
function submitDeviceConfigurationForm()\
{\
return;\
}\
function submitCreateForm()\
{\
var list = document.getElementById(\"type\");\
var type = list.options[list.selectedIndex].value;\
var name = document.getElementById(\"name\").value;\
if(name === \"\") \
return;\
var arg = document.getElementById(\"arg\").value;\
var url;\
if(arg === \"\") url = \"http://\" + ip + type + \"new?name=\" + name;\
else url = \"http://\" + ip + type + \"new?arg=\" + arg + \"&name=\" + name;\
location.href= url;\
}\
function submitCallFuncForm()\
{\
var command = document.getElementById(\"command\").value;\
if(command === \"\") \
return; \
var tmp = command.split(\' \');\
var url = tmp[0];\
if(tmp.length > 1)\
url += \"?\";\
for(var i = 1; i < tmp.length; ++i)\
{\
url += \"arg\" + i + \"=\" + tmp[i];\
if(i+1 < tmp.length)\
url += \"&\";\
}\
location.href = url;\
}\
</script>\
</head> \
<body>";

const char* INTERACTIVE_HTML_CODE_2 = "<h3>Device Configuration (not yet)</h3>\
<form>\
IP (x.x.x.x): <input type=\"text\" id=\"ipaddr\"><br>\
Subnet (x.x.x.x): <input type=\"text\" id=\"subnet\"><br>\
Gateway (x.x.x.x): <input type=\"text\" id=\"gateway\"><br>\
MAC (x.x.x): <input type=\"text\" id=\"mac\">\
<p><input type=\"button\" value=\"Save\" onclick=\"javascript:submitDeviceConfigurationForm();\"></p>\
</form> \
\
<h3>Create Object</h3>\
<form>\
Type: <select id=\"type\">\
<option value=\"/DigitalOut/\">DigitalOut</option>\
<option value=\"/DigitalIn/\">DigitalIn</option>\
<option value=\"/DigitalInOut/\">DigitalInOut</option>\
<option value=\"/AnalogIn/\">AnalogIn</option>\
<option value=\"/PwmOut/\">PwmOut</option>\
<option value=\"/Timer/\">Timer</option>\
</select><br>\
name: <input type=\"text\" id=\"name\"><br>\
arg(optional): <input type=\"text\" id=\"arg\">\
<p><input type=\"button\" value=\"Create\" onclick=\"javascript:submitCreateForm();\"></p>\
</form> \
 \
<h3>Call a function</h3>\
<p>Enter an RPC command.</p>\
<form>\
Command: <input type= \"text\" id=\"command\" maxlength=127><br>\
<p><input type=\"button\" value=\"Send\" onclick=\"javascript:submitCallFuncForm();\"></p><br>\
</form>\
</body> \
</html>";


static char chunk[2048]; // Need to update according to HTML content
        
Formatter::Formatter(int nb):
currentChunk(0),
nbChunk(nb)
{
}    

char* Formatter::get_page(char *reply)
{
    chunk[0] = '\0';

    if(currentChunk < nbChunk)
    {
        get_chunk(currentChunk, reply);
        currentChunk++;
    }
    else
        currentChunk = 0;
    
    return chunk;
}    

void Formatter::get_chunk(const int c, char *reply)
{
    strcat(chunk, reply);
}

SimpleHTMLFormatter::SimpleHTMLFormatter():
Formatter()
{
}

void SimpleHTMLFormatter::get_chunk(const int c, char* reply)
{
    strcat(chunk, SIMPLE_HTML_CODE);
    
    if(reply != NULL && strlen(reply) != 0)
    {
        strcat(chunk, "RPC reply : ");
        strcat(chunk, reply);
    }
        
    if(!RPCObjectManager::instance().is_empty())
    {
        strcat(chunk, "<ul>");
        for(std::list<char*>::iterator itor = RPCObjectManager::instance().begin();
            itor != RPCObjectManager::instance().end();
            ++itor)
        {
            strcat(chunk, "<li>");
            strcat(chunk, *itor);
            strcat(chunk, "</li>");
        }
        strcat(chunk, "</ul>");
    }
    
    strcat(chunk, "</body></html>");
}

InteractiveHTMLFormatter::InteractiveHTMLFormatter():
Formatter(3)
{
}

void InteractiveHTMLFormatter::get_chunk(const int c, char *reply)
{
    if(c == 0)
        //sprintf(chunk, INTERACTIVE_HTML_CODE_1, EthernetInterface::getIPAddress());
        sprintf(chunk, INTERACTIVE_HTML_CODE_1, eth.getIPAddress());

    else if(c == 1)
    {
        if(reply != NULL && strlen(reply) != 0)
        {
            strcat(chunk, "RPC reply : ");
            strcat(chunk, reply);
        }
        if(!RPCObjectManager::instance().is_empty())
        {
            strcat(chunk, "<p>Objects created :</p>");

            strcat(chunk, "<ul>");
            for(std::list<char*>::iterator itor = RPCObjectManager::instance().begin();
                itor != RPCObjectManager::instance().end();
                ++itor)
            {
                strcat(chunk, "<li>");
                strcat(chunk, *itor);
                strcat(chunk, " (<a href=\"http://");
                //strcat(chunk, EthernetInterface::getIPAddress());
                strcat(chunk, eth.getIPAddress());
                strcat(chunk, "/");
                strcat(chunk, *itor);
                strcat(chunk, "/delete\">delete</a>)");
                strcat(chunk, "</li>");
            }
            strcat(chunk, "</ul>");
        }
        strcat(chunk, " ");
    }
    else if(c == 2)
        strcat(chunk, INTERACTIVE_HTML_CODE_2);
}


