#include "mbed.h"
#include "C027.h"
#include "EthernetInterface.h"
#include "HTTPClient.h"


#define XI_FEED_ID 607813696 // set Xively Feed ID (numerical, no quoutes)
#define XI_API_KEY "DcO8pnBiF4N0xyT9cPeQLggUHuNu7g8dwYhxH6s1qjZwtZm5" // set Xively API key (double-quoted string)
 
#include "xively.h"
#include "xi_err.h"

//Debug is disabled by default
#if 1
//Enable debug
#include <cstdio>
#define DBG(x, ...) std::printf("[main : DBG]"x"\r\n", ##__VA_ARGS__); 
#define WARN(x, ...) std::printf("[main : WARN]"x"\r\n", ##__VA_ARGS__); 
#define ERR(x, ...) std::printf("[main : ERR]"x"\r\n", ##__VA_ARGS__); 

#else
//Disable debug
#define DBG(x, ...) 
#define WARN(x, ...)
#define ERR(x, ...) 

#endif

void xively_test(void const*) {
    /*
     * Setup Ethernet interface
     */
    EthernetInterface eth;
    eth.init(); //Use DHCP
    eth.connect();
    DBG("IP Address is %s", eth.getIPAddress());
    
    /*
     * HTTPClient for location
     */
    HTTPClient http; 
    
    /*
     * Setup Xively parameters
     */
    xi_feed_t feed;
    memset(&feed, NULL, sizeof(xi_feed_t));
    
    // channels
    feed.feed_id = XI_FEED_ID;
    feed.datastream_count = 1; // number of channels
    
    // channel settings
    feed.datastreams[0].datapoint_count = 1;
    xi_datastream_t* counter_datastream = &feed.datastreams[0];
    strcpy(counter_datastream->datastream_id, "counter"); // name of channel
    xi_datapoint_t* counter = &counter_datastream->datapoints[0]; // xively channel variable to set value
 
    // create the cosm library context
    xi_context_t* xi_context = xi_create_context(XI_HTTP, XI_API_KEY, feed.feed_id);
 
    // check if everything works
    if (xi_context == NULL)
    {
        DBG("xi_context = NULL");
    }
    
    char url[64];
    char json[256];
    char request[256], response[128];
    
    // prepare url
    sprintf(url, "https://api.xively.com/v2/feeds/%d.json", XI_FEED_ID);
    
    // prepare json string
    sprintf(json,"{\r\n\"location\": {\r\n\"disposition\": \"mobile\",\r\n\"name\": \"Monuriki Island\",\r\n\"exposure\": \"outdoor\",\r\n\"domain\": \"physical\",\r\n\"ele\": \"370000\",\r\n\"lat\": 17.609991828964787,\r\n\"lon\": 178.03402996826273\r\n}\r\n}\r\n");
    DBG("%s", json);
    int length = 0;
    while (json[length] != 0) length++;
    DBG("json length = %d", length);
    
    // prepare request to PUT
    sprintf(request,"%s", json);
    length = 0;
    while (request[length] != 0) length++;
    DBG("request length = %d", length);

    // Loop for sending data to Xively
    long unsigned int c = 0; // counter value
    while(1) {
      xi_set_value_i32(counter, ++c);
        
      DBG("Updating Xively feed %d: %d", XI_FEED_ID, c);
      xi_feed_update(xi_context, &feed);
      
      // location
      sprintf(response, "X-ApiKey: %s", XI_API_KEY);
      HTTPTextXively requestText(request);
      HTTPTextXively responseText(response,128);
      
      // prepare specific headers to PUT, put in pDataIn
      int ret = http.put(url,requestText,&responseText);
      wait(10);
    }
}

int main()
{
    Thread testTask(xively_test, NULL, osPriorityNormal, 1024 * 4);
    DigitalOut led(LED); // on rev A you should reasign the signal to A0
    while(1) {
        led=!led;
        Thread::wait(1000);
    }

    return 0;
}