#include "mbed.h"
#include "C027.h"
#include "EthernetInterface.h"
#include "Websocket.h"
#include "SocketIO.h"


//Debug is disabled by default
#if 0
//Enable debug
#include <cstdio>
#define DBG(x, ...) std::printf("[main : DBG]"x"\r\n", ##__VA_ARGS__); 
#define WARN(x, ...) std::printf("[main : WARN]"x"\r\n", ##__VA_ARGS__); 
#define ERR(x, ...) std::printf("[main : ERR]"x"\r\n", ##__VA_ARGS__); 

#else
//Disable debug
#define DBG(x, ...) 
#define WARN(x, ...)
#define ERR(x, ...) 

#endif


void websocket_test(void const*)
{
    char msg[512] = {0};

    EthernetInterface eth;
    eth.init(); //Use DHCP
    eth.connect();
    DBG("IP Address is %s", eth.getIPAddress());

    Websocket ws("ws://sockets.mbed.org:443/ws/chauvo/wo");
    Timer t;
    t.start();

    bool c = ws.connect();
    DBG("Connect result: %s", c?"OK":"Failed");

    for(int i = 0; i < 10000; i++) {
        ws.connect();
        // create json string with acc/tmp data
        sprintf(msg, "Chau's demo loop: %d", i);
        ws.send(msg);
        wait(0.5f);
        memset(msg, 0, 512);

        if (ws.read(msg)) {
            DBG("rcv: %s\r\n", msg);
        } else {
            DBG("Loop %d ws.read() returns 0\n \t %s, line %d @ %6.2f seconds\n", i, __FILE__, __LINE__, t.read());
            wait(5.0f);
        }
        ws.close();
    }

    while(1) {
    }
}

void socketio_test(void const*)
{
    char msg[512] = {0};

    EthernetInterface eth;
    eth.init(); //Use DHCP
    eth.connect();
    DBG("IP Address is %s", eth.getIPAddress());

    //SocketIO socketio("websocket-server-c9-chau_vk.c9.io");
    SocketIO socketio("nne-server1.herokuapp.com");
    //SocketIO socketio("nneserver1-tutorial11067089.rhcloud.com");

    bool c = socketio.connect();
    //DBG("Connect result: %s", c?"OK":"Failed");

    Timer t;
    t.start();
    while (1) {
        socketio.connect();
        if (t.read() > 10) {
            socketio.emit("message","0.5");
            DBG("sent");
            t.reset();
        }
        if (socketio.read(msg)) {
            DBG("rcv: %s", msg);
        }
        //wait(10);
    }
}

int main()
{
    //Thread testTask(websocket_test, NULL, osPriorityNormal, 1024 * 4);
    Thread testTask(socketio_test, NULL, osPriorityNormal, 1024 * 4);
    DigitalOut led(LED); // on rev A you should reasign the signal to A0
    while(1) {
        led=!led;
        Thread::wait(1000);
    }

    return 0;
}