#include "mbed.h"

/* 
 * Links
 * https://gist.github.com/franciscospaeth/8503747
 * http://embeddedprogrammer.blogspot.co.uk/2012/07/hacking-ov7670-camera-module-sccb-cheat.html
 * http://www.voti.nl/docs/OV7670.pdf
 */

#define CAMERA_W 176
#define CAMERA_H 144
#define CAMERA_BPX 2 // bits per pixel
#define CAMERA_CLK_PERIOD 1e-6

#define CAMERA_I2C_FREQ 40000
#define CAMERA_I2C_READ_ADDR 0x43
#define CAMERA_I2C_WRITE_ADDR 0x42
#define CAMERA_I2C_NOACK 0
#define CAMERA_I2C_REGMAX 201


#define CAMERA_I2C_REG_COM3 0x0C
#define CAMERA_I2C_REG_COM4 0x0D
#define CAMERA_I2C_REG_COM5 0x0E
#define CAMERA_I2C_REG_COM6 0x0F
#define CAMERA_I2C_REG_AECH 0x10
#define CAMERA_I2C_REG_CLKRC 0x11
#define CAMERA_I2C_REG_COM7 0x12
#define CAMERA_I2C_REG_COM8 0x13
#define CAMERA_I2C_REG_COM9 0x14
#define CAMERA_I2C_REG_COM10 0x15
#define CAMERA_I2C_REG_COM11 0x3B
#define CAMERA_I2C_REG_COM12 0x3C
#define CAMERA_I2C_REG_COM13 0x3D
#define CAMERA_I2C_REG_COM14 0x3E

#define CAMERA_I2C_OF_CIF 32
#define CAMERA_I2C_OF_QVGA 16
#define CAMERA_I2C_OF_QCIF 8 // 176 x 144
#define CAMERA_I2C_OF_RGB 4
#define CAMERA_I2C_OF_YUV 0

void camera_setup();
int camera_i2c_read(int addr);
void camera_i2c_write(int addr, int val);
void camera_set_freq_scaler(int prescaler);
void camera_set_output_format(int output_format);
void camera_grab(FILE *fp);


void wait_posedge(DigitalIn pin);
void wait_negedge(DigitalIn pin);