#ifndef JAUDIO_STREAM_H
#define JAUDIO_STREAM_H
#include "mbed.h"
#include "EthernetInterface.h"
#include "UDPSocket.h"

#define MAX_PACKT 32
#define MESSAGE_SIZE 8
#define MESSAGE_COMP_SIZE 4
#define REQUEST_RESPONSE_MODE 1

class JAudioStream {
    private:
        const char* cont;
        const char* cond;
        const char* dcon;
        const char* dctd;
        const char* rqst;
        const char* begn;
        const char* comt;
        const char* hrbt;
        typedef void (*OnStream)(char*);
        void (*streamCallback) (char*);
        int bufferSize;
        int requestCount;
        EthernetInterface eth;
        UDPSocket socket;
        Endpoint endPoint;
        char* remoteIp;
        short remotePort;
        volatile bool connected;
        volatile bool inTransmission;
        void buildMeassge(const char*, int, char*);
        void buildMeassge(const char*, int, char*, char*);
        void intTocharArr(int, char*);
        void send(char*, int);
        void request(char);
        bool read(char*, int);
        char* nowPlaying;
    public:
        JAudioStream(OnStream, int);
        bool connect(char *, int, char *);
        bool isConnected();
        char* getNowPlaying();
        void disconnect();
        int loop();
};

#endif