#include "JAudioStream.h"
#define LOG_LEVEL_INFO
#include "logger.h"

JAudioStream::JAudioStream(OnStream streamCallback, int bufferSize) {
    this->streamCallback = streamCallback;
    this->bufferSize = bufferSize;
    requestCount = bufferSize / MAX_PACKT;
    cont = "cont";
    cond = "cond";
    dcon = "dcon";
    dctd = "dctd";
    rqst = "rqst";
    begn = "begn";
    comt = "comt";
    hrbt = "hrbt";
    connected = false;
    inTransmission = false;
}

bool JAudioStream::connect(char* ip, int port, char* name) {
    eth.init();
    eth.connect();
    socket.init();
    socket.set_blocking(false, 500);
    remotePort = port;
    remoteIp = ip;
    endPoint.set_address(ip, port);
    char message[MESSAGE_SIZE*2];
    buildMeassge(cont, REQUEST_RESPONSE_MODE, name, message);
    send(message, MESSAGE_SIZE*2);    
    return connected;
}

bool JAudioStream::read(char *buffer, int size) {
    TRACE("Received %s", buffer);
    if (socket.receiveFrom(endPoint, buffer, size)) {
        return true;    
    }
    return false;
}

bool JAudioStream::isConnected() {
    return connected;
}

void JAudioStream::request(char amount) {
    char message[MESSAGE_SIZE];
    buildMeassge(rqst, amount, message);
    send(message, MESSAGE_SIZE);
}

void JAudioStream::disconnect() {
    char message[MESSAGE_SIZE];
    buildMeassge(dcon, -1, message);
    send(message, MESSAGE_SIZE);
}

void JAudioStream::buildMeassge(const char* cmd, int param, char* message) {
    char bParam[MESSAGE_COMP_SIZE];
    intTocharArr(param, bParam);
    char i;
    for (i=0; i<MESSAGE_COMP_SIZE; i++) {
        message[i] = cmd[i];
    }
    for (i=MESSAGE_COMP_SIZE; i<MESSAGE_SIZE; i++) {
        message[i] = bParam[i-MESSAGE_COMP_SIZE];
    }
}

void JAudioStream::buildMeassge(const char* cmd, int param, char* data, char* message) {
    char bParam[MESSAGE_COMP_SIZE];
    char i;
    for (i=0; i<MESSAGE_COMP_SIZE; i++) {
        message[i] = cmd[i];
    }
    intTocharArr(param, bParam);
    for (i=MESSAGE_COMP_SIZE; i<MESSAGE_SIZE; i++) {
        message[i] = bParam[i-MESSAGE_COMP_SIZE];
    }
    char dataSize = MESSAGE_SIZE*2;
    for (i=MESSAGE_SIZE; i<dataSize; i++) {
        message[i] = data[i-MESSAGE_SIZE];
    }
}

void JAudioStream::intTocharArr(int value, char* buff) {
    buff[0] = (value >> 24) & 0xFF;
    buff[1] = (value >> 16) & 0xFF;
    buff[2] = (value >> 8) & 0xFF;
    buff[3] = value;
}

void JAudioStream::send(char* data, int size ) {
    TRACE("Sending %s", data);
    socket.sendTo(endPoint, data, size);
}

char* JAudioStream::getNowPlaying() {
    return nowPlaying;
}

int JAudioStream::loop() {
    int result = 0;
    char resp[MAX_PACKT];
    if (read(resp, MAX_PACKT)) {
        if (memcmp(resp, cond, 4) == 0) {
            connected = true;
        } else if (memcmp(resp, dctd, 4) == 0) {
            connected = false;
            result = 1;
        } else if (memcmp(resp, hrbt, 4) == 0) {
            char message[MESSAGE_SIZE];
            buildMeassge(hrbt, -1, message);
            send(message, MESSAGE_SIZE);     
        } else if (memcmp(resp, begn, 4) == 0) {
            memmove(&nowPlaying[0], &resp[4], 20);
            inTransmission = true;
        } else if (memcmp(resp, comt, 4) == 0) {
            inTransmission = false;
        } else {
            char buffer[bufferSize];
            char i = 0;
            while (i < requestCount) {
                stream.request(MAX_PACKT);
                char buff[MAX_PACKT];
                if (stream.read(buff, MAX_PACKT)) {
                    memmove(&buffer[i*MAX_PACKT], &buff[0], MAX_PACKT);
                    i++;    
                } else {
                    WARN("Timed out waiting for response");    
                }
            }
            streamCallback(buffer);
        }
        return result;
    }
}
